// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearningCompute.Models
{
    /// <summary> Yes if updates are available for the system services, No if not. </summary>
    public readonly partial struct UpdatesAvailable : IEquatable<UpdatesAvailable>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UpdatesAvailable"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UpdatesAvailable(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string YesValue = "Yes";
        private const string NoValue = "No";

        /// <summary> Yes. </summary>
        public static UpdatesAvailable Yes { get; } = new UpdatesAvailable(YesValue);
        /// <summary> No. </summary>
        public static UpdatesAvailable No { get; } = new UpdatesAvailable(NoValue);
        /// <summary> Determines if two <see cref="UpdatesAvailable"/> values are the same. </summary>
        public static bool operator ==(UpdatesAvailable left, UpdatesAvailable right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UpdatesAvailable"/> values are not the same. </summary>
        public static bool operator !=(UpdatesAvailable left, UpdatesAvailable right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UpdatesAvailable"/>. </summary>
        public static implicit operator UpdatesAvailable(string value) => new UpdatesAvailable(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UpdatesAvailable other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UpdatesAvailable other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
