// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearningCompute.Models
{
    /// <summary> Response of the update system services API. </summary>
    public partial class UpdateSystemServicesResponse
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UpdateSystemServicesResponse"/>. </summary>
        internal UpdateSystemServicesResponse()
        {
        }

        /// <summary> Initializes a new instance of <see cref="UpdateSystemServicesResponse"/>. </summary>
        /// <param name="updateStatus"> Update status. </param>
        /// <param name="updateStartedOn"> The date and time when the last system services update was started. </param>
        /// <param name="updateCompletedOn"> The date and time when the last system services update completed. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UpdateSystemServicesResponse(OperationStatus? updateStatus, DateTimeOffset? updateStartedOn, DateTimeOffset? updateCompletedOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UpdateStatus = updateStatus;
            UpdateStartedOn = updateStartedOn;
            UpdateCompletedOn = updateCompletedOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Update status. </summary>
        public OperationStatus? UpdateStatus { get; }
        /// <summary> The date and time when the last system services update was started. </summary>
        public DateTimeOffset? UpdateStartedOn { get; }
        /// <summary> The date and time when the last system services update completed. </summary>
        public DateTimeOffset? UpdateCompletedOn { get; }
    }
}
