// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearningCompute.Models
{
    /// <summary> The system service type. </summary>
    public readonly partial struct SystemServiceType : IEquatable<SystemServiceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SystemServiceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SystemServiceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ScoringFrontEndValue = "ScoringFrontEnd";
        private const string BatchFrontEndValue = "BatchFrontEnd";

        /// <summary> None. </summary>
        public static SystemServiceType None { get; } = new SystemServiceType(NoneValue);
        /// <summary> ScoringFrontEnd. </summary>
        public static SystemServiceType ScoringFrontEnd { get; } = new SystemServiceType(ScoringFrontEndValue);
        /// <summary> BatchFrontEnd. </summary>
        public static SystemServiceType BatchFrontEnd { get; } = new SystemServiceType(BatchFrontEndValue);
        /// <summary> Determines if two <see cref="SystemServiceType"/> values are the same. </summary>
        public static bool operator ==(SystemServiceType left, SystemServiceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SystemServiceType"/> values are not the same. </summary>
        public static bool operator !=(SystemServiceType left, SystemServiceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SystemServiceType"/>. </summary>
        public static implicit operator SystemServiceType(string value) => new SystemServiceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SystemServiceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SystemServiceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
