// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearningCompute.Models
{
    /// <summary> Resource operation. </summary>
    public partial class ResourceOperation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceOperation"/>. </summary>
        internal ResourceOperation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ResourceOperation"/>. </summary>
        /// <param name="name"> Name of this operation. </param>
        /// <param name="display"> Display of the operation. </param>
        /// <param name="origin"> The operation origin. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceOperation(string name, ResourceOperationDisplay display, string origin, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Display = display;
            Origin = origin;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of this operation. </summary>
        public string Name { get; }
        /// <summary> Display of the operation. </summary>
        public ResourceOperationDisplay Display { get; }
        /// <summary> The operation origin. </summary>
        public string Origin { get; }
    }
}
