// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearningCompute.Models
{
    /// <summary> The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. </summary>
    public readonly partial struct OperationStatus : IEquatable<OperationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OperationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OperationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string UpdatingValue = "Updating";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Unknown. </summary>
        public static OperationStatus Unknown { get; } = new OperationStatus(UnknownValue);
        /// <summary> Updating. </summary>
        public static OperationStatus Updating { get; } = new OperationStatus(UpdatingValue);
        /// <summary> Creating. </summary>
        public static OperationStatus Creating { get; } = new OperationStatus(CreatingValue);
        /// <summary> Deleting. </summary>
        public static OperationStatus Deleting { get; } = new OperationStatus(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static OperationStatus Succeeded { get; } = new OperationStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static OperationStatus Failed { get; } = new OperationStatus(FailedValue);
        /// <summary> Canceled. </summary>
        public static OperationStatus Canceled { get; } = new OperationStatus(CanceledValue);
        /// <summary> Determines if two <see cref="OperationStatus"/> values are the same. </summary>
        public static bool operator ==(OperationStatus left, OperationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OperationStatus"/> values are not the same. </summary>
        public static bool operator !=(OperationStatus left, OperationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OperationStatus"/>. </summary>
        public static implicit operator OperationStatus(string value) => new OperationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OperationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OperationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
