// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearningCompute.Models
{
    /// <summary> Information about the Azure Container Registry which contains the images deployed to the cluster. </summary>
    public partial class ContainerServiceCredentials
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceCredentials"/>. </summary>
        internal ContainerServiceCredentials()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerServiceCredentials"/>. </summary>
        /// <param name="acsKubeConfig"> The ACS kube config file. </param>
        /// <param name="servicePrincipalConfiguration"> Service principal configuration used by Kubernetes. </param>
        /// <param name="imagePullSecretName"> The ACR image pull secret name which was created in Kubernetes. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerServiceCredentials(string acsKubeConfig, ServicePrincipalProperties servicePrincipalConfiguration, string imagePullSecretName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AcsKubeConfig = acsKubeConfig;
            ServicePrincipalConfiguration = servicePrincipalConfiguration;
            ImagePullSecretName = imagePullSecretName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The ACS kube config file. </summary>
        public string AcsKubeConfig { get; }
        /// <summary> Service principal configuration used by Kubernetes. </summary>
        public ServicePrincipalProperties ServicePrincipalConfiguration { get; }
        /// <summary> The ACR image pull secret name which was created in Kubernetes. </summary>
        public string ImagePullSecretName { get; }
    }
}
