// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearningCompute.Models
{
    /// <summary> The cluster type. </summary>
    public readonly partial struct ClusterType : IEquatable<ClusterType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ACSValue = "ACS";
        private const string LocalValue = "Local";

        /// <summary> ACS. </summary>
        public static ClusterType ACS { get; } = new ClusterType(ACSValue);
        /// <summary> Local. </summary>
        public static ClusterType Local { get; } = new ClusterType(LocalValue);
        /// <summary> Determines if two <see cref="ClusterType"/> values are the same. </summary>
        public static bool operator ==(ClusterType left, ClusterType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterType"/> values are not the same. </summary>
        public static bool operator !=(ClusterType left, ClusterType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterType"/>. </summary>
        public static implicit operator ClusterType(string value) => new ClusterType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
