// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearningCompute.Models
{
    /// <summary> AutoScale configuration properties. </summary>
    public partial class AutoScaleConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutoScaleConfiguration"/>. </summary>
        public AutoScaleConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AutoScaleConfiguration"/>. </summary>
        /// <param name="status"> If auto-scale is enabled for all services. Each service can turn it off individually. </param>
        /// <param name="minReplicas"> The minimum number of replicas for each service. </param>
        /// <param name="maxReplicas"> The maximum number of replicas for each service. </param>
        /// <param name="targetUtilization"> The target utilization. </param>
        /// <param name="refreshPeriodInSeconds"> Refresh period in seconds. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutoScaleConfiguration(Status? status, int? minReplicas, int? maxReplicas, float? targetUtilization, int? refreshPeriodInSeconds, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            MinReplicas = minReplicas;
            MaxReplicas = maxReplicas;
            TargetUtilization = targetUtilization;
            RefreshPeriodInSeconds = refreshPeriodInSeconds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> If auto-scale is enabled for all services. Each service can turn it off individually. </summary>
        public Status? Status { get; set; }
        /// <summary> The minimum number of replicas for each service. </summary>
        public int? MinReplicas { get; set; }
        /// <summary> The maximum number of replicas for each service. </summary>
        public int? MaxReplicas { get; set; }
        /// <summary> The target utilization. </summary>
        public float? TargetUtilization { get; set; }
        /// <summary> Refresh period in seconds. </summary>
        public int? RefreshPeriodInSeconds { get; set; }
    }
}
