// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearningCompute.Models
{
    /// <summary> AppInsights credentials. </summary>
    public partial class AppInsightsCredentials
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppInsightsCredentials"/>. </summary>
        internal AppInsightsCredentials()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AppInsightsCredentials"/>. </summary>
        /// <param name="appId"> The AppInsights application ID. </param>
        /// <param name="instrumentationKey"> The AppInsights instrumentation key. This is not returned in response of GET/PUT on the resource. To see this please call listKeys API. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppInsightsCredentials(string appId, string instrumentationKey, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AppId = appId;
            InstrumentationKey = instrumentationKey;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The AppInsights application ID. </summary>
        public string AppId { get; }
        /// <summary> The AppInsights instrumentation key. This is not returned in response of GET/PUT on the resource. To see this please call listKeys API. </summary>
        public string InstrumentationKey { get; }
    }
}
