// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearningCompute.Models
{
    /// <summary> The Azure VM size of the agent VM nodes. This cannot be changed once the cluster is created. This list is non exhaustive; refer to https://docs.microsoft.com/en-us/azure/virtual-machines/windows/sizes for the possible VM sizes. </summary>
    public readonly partial struct AgentVmSizeType : IEquatable<AgentVmSizeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AgentVmSizeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AgentVmSizeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardA0Value = "Standard_A0";
        private const string StandardA1Value = "Standard_A1";
        private const string StandardA2Value = "Standard_A2";
        private const string StandardA3Value = "Standard_A3";
        private const string StandardA4Value = "Standard_A4";
        private const string StandardA5Value = "Standard_A5";
        private const string StandardA6Value = "Standard_A6";
        private const string StandardA7Value = "Standard_A7";
        private const string StandardA8Value = "Standard_A8";
        private const string StandardA9Value = "Standard_A9";
        private const string StandardA10Value = "Standard_A10";
        private const string StandardA11Value = "Standard_A11";
        private const string StandardD1Value = "Standard_D1";
        private const string StandardD2Value = "Standard_D2";
        private const string StandardD3Value = "Standard_D3";
        private const string StandardD4Value = "Standard_D4";
        private const string StandardD11Value = "Standard_D11";
        private const string StandardD12Value = "Standard_D12";
        private const string StandardD13Value = "Standard_D13";
        private const string StandardD14Value = "Standard_D14";
        private const string StandardD1V2Value = "Standard_D1_v2";
        private const string StandardD2V2Value = "Standard_D2_v2";
        private const string StandardD3V2Value = "Standard_D3_v2";
        private const string StandardD4V2Value = "Standard_D4_v2";
        private const string StandardD5V2Value = "Standard_D5_v2";
        private const string StandardD11V2Value = "Standard_D11_v2";
        private const string StandardD12V2Value = "Standard_D12_v2";
        private const string StandardD13V2Value = "Standard_D13_v2";
        private const string StandardD14V2Value = "Standard_D14_v2";
        private const string StandardG1Value = "Standard_G1";
        private const string StandardG2Value = "Standard_G2";
        private const string StandardG3Value = "Standard_G3";
        private const string StandardG4Value = "Standard_G4";
        private const string StandardG5Value = "Standard_G5";
        private const string StandardDS1Value = "Standard_DS1";
        private const string StandardDS2Value = "Standard_DS2";
        private const string StandardDS3Value = "Standard_DS3";
        private const string StandardDS4Value = "Standard_DS4";
        private const string StandardDS11Value = "Standard_DS11";
        private const string StandardDS12Value = "Standard_DS12";
        private const string StandardDS13Value = "Standard_DS13";
        private const string StandardDS14Value = "Standard_DS14";
        private const string StandardGS1Value = "Standard_GS1";
        private const string StandardGS2Value = "Standard_GS2";
        private const string StandardGS3Value = "Standard_GS3";
        private const string StandardGS4Value = "Standard_GS4";
        private const string StandardGS5Value = "Standard_GS5";

        /// <summary> Standard_A0. </summary>
        public static AgentVmSizeType StandardA0 { get; } = new AgentVmSizeType(StandardA0Value);
        /// <summary> Standard_A1. </summary>
        public static AgentVmSizeType StandardA1 { get; } = new AgentVmSizeType(StandardA1Value);
        /// <summary> Standard_A2. </summary>
        public static AgentVmSizeType StandardA2 { get; } = new AgentVmSizeType(StandardA2Value);
        /// <summary> Standard_A3. </summary>
        public static AgentVmSizeType StandardA3 { get; } = new AgentVmSizeType(StandardA3Value);
        /// <summary> Standard_A4. </summary>
        public static AgentVmSizeType StandardA4 { get; } = new AgentVmSizeType(StandardA4Value);
        /// <summary> Standard_A5. </summary>
        public static AgentVmSizeType StandardA5 { get; } = new AgentVmSizeType(StandardA5Value);
        /// <summary> Standard_A6. </summary>
        public static AgentVmSizeType StandardA6 { get; } = new AgentVmSizeType(StandardA6Value);
        /// <summary> Standard_A7. </summary>
        public static AgentVmSizeType StandardA7 { get; } = new AgentVmSizeType(StandardA7Value);
        /// <summary> Standard_A8. </summary>
        public static AgentVmSizeType StandardA8 { get; } = new AgentVmSizeType(StandardA8Value);
        /// <summary> Standard_A9. </summary>
        public static AgentVmSizeType StandardA9 { get; } = new AgentVmSizeType(StandardA9Value);
        /// <summary> Standard_A10. </summary>
        public static AgentVmSizeType StandardA10 { get; } = new AgentVmSizeType(StandardA10Value);
        /// <summary> Standard_A11. </summary>
        public static AgentVmSizeType StandardA11 { get; } = new AgentVmSizeType(StandardA11Value);
        /// <summary> Standard_D1. </summary>
        public static AgentVmSizeType StandardD1 { get; } = new AgentVmSizeType(StandardD1Value);
        /// <summary> Standard_D2. </summary>
        public static AgentVmSizeType StandardD2 { get; } = new AgentVmSizeType(StandardD2Value);
        /// <summary> Standard_D3. </summary>
        public static AgentVmSizeType StandardD3 { get; } = new AgentVmSizeType(StandardD3Value);
        /// <summary> Standard_D4. </summary>
        public static AgentVmSizeType StandardD4 { get; } = new AgentVmSizeType(StandardD4Value);
        /// <summary> Standard_D11. </summary>
        public static AgentVmSizeType StandardD11 { get; } = new AgentVmSizeType(StandardD11Value);
        /// <summary> Standard_D12. </summary>
        public static AgentVmSizeType StandardD12 { get; } = new AgentVmSizeType(StandardD12Value);
        /// <summary> Standard_D13. </summary>
        public static AgentVmSizeType StandardD13 { get; } = new AgentVmSizeType(StandardD13Value);
        /// <summary> Standard_D14. </summary>
        public static AgentVmSizeType StandardD14 { get; } = new AgentVmSizeType(StandardD14Value);
        /// <summary> Standard_D1_v2. </summary>
        public static AgentVmSizeType StandardD1V2 { get; } = new AgentVmSizeType(StandardD1V2Value);
        /// <summary> Standard_D2_v2. </summary>
        public static AgentVmSizeType StandardD2V2 { get; } = new AgentVmSizeType(StandardD2V2Value);
        /// <summary> Standard_D3_v2. </summary>
        public static AgentVmSizeType StandardD3V2 { get; } = new AgentVmSizeType(StandardD3V2Value);
        /// <summary> Standard_D4_v2. </summary>
        public static AgentVmSizeType StandardD4V2 { get; } = new AgentVmSizeType(StandardD4V2Value);
        /// <summary> Standard_D5_v2. </summary>
        public static AgentVmSizeType StandardD5V2 { get; } = new AgentVmSizeType(StandardD5V2Value);
        /// <summary> Standard_D11_v2. </summary>
        public static AgentVmSizeType StandardD11V2 { get; } = new AgentVmSizeType(StandardD11V2Value);
        /// <summary> Standard_D12_v2. </summary>
        public static AgentVmSizeType StandardD12V2 { get; } = new AgentVmSizeType(StandardD12V2Value);
        /// <summary> Standard_D13_v2. </summary>
        public static AgentVmSizeType StandardD13V2 { get; } = new AgentVmSizeType(StandardD13V2Value);
        /// <summary> Standard_D14_v2. </summary>
        public static AgentVmSizeType StandardD14V2 { get; } = new AgentVmSizeType(StandardD14V2Value);
        /// <summary> Standard_G1. </summary>
        public static AgentVmSizeType StandardG1 { get; } = new AgentVmSizeType(StandardG1Value);
        /// <summary> Standard_G2. </summary>
        public static AgentVmSizeType StandardG2 { get; } = new AgentVmSizeType(StandardG2Value);
        /// <summary> Standard_G3. </summary>
        public static AgentVmSizeType StandardG3 { get; } = new AgentVmSizeType(StandardG3Value);
        /// <summary> Standard_G4. </summary>
        public static AgentVmSizeType StandardG4 { get; } = new AgentVmSizeType(StandardG4Value);
        /// <summary> Standard_G5. </summary>
        public static AgentVmSizeType StandardG5 { get; } = new AgentVmSizeType(StandardG5Value);
        /// <summary> Standard_DS1. </summary>
        public static AgentVmSizeType StandardDS1 { get; } = new AgentVmSizeType(StandardDS1Value);
        /// <summary> Standard_DS2. </summary>
        public static AgentVmSizeType StandardDS2 { get; } = new AgentVmSizeType(StandardDS2Value);
        /// <summary> Standard_DS3. </summary>
        public static AgentVmSizeType StandardDS3 { get; } = new AgentVmSizeType(StandardDS3Value);
        /// <summary> Standard_DS4. </summary>
        public static AgentVmSizeType StandardDS4 { get; } = new AgentVmSizeType(StandardDS4Value);
        /// <summary> Standard_DS11. </summary>
        public static AgentVmSizeType StandardDS11 { get; } = new AgentVmSizeType(StandardDS11Value);
        /// <summary> Standard_DS12. </summary>
        public static AgentVmSizeType StandardDS12 { get; } = new AgentVmSizeType(StandardDS12Value);
        /// <summary> Standard_DS13. </summary>
        public static AgentVmSizeType StandardDS13 { get; } = new AgentVmSizeType(StandardDS13Value);
        /// <summary> Standard_DS14. </summary>
        public static AgentVmSizeType StandardDS14 { get; } = new AgentVmSizeType(StandardDS14Value);
        /// <summary> Standard_GS1. </summary>
        public static AgentVmSizeType StandardGS1 { get; } = new AgentVmSizeType(StandardGS1Value);
        /// <summary> Standard_GS2. </summary>
        public static AgentVmSizeType StandardGS2 { get; } = new AgentVmSizeType(StandardGS2Value);
        /// <summary> Standard_GS3. </summary>
        public static AgentVmSizeType StandardGS3 { get; } = new AgentVmSizeType(StandardGS3Value);
        /// <summary> Standard_GS4. </summary>
        public static AgentVmSizeType StandardGS4 { get; } = new AgentVmSizeType(StandardGS4Value);
        /// <summary> Standard_GS5. </summary>
        public static AgentVmSizeType StandardGS5 { get; } = new AgentVmSizeType(StandardGS5Value);
        /// <summary> Determines if two <see cref="AgentVmSizeType"/> values are the same. </summary>
        public static bool operator ==(AgentVmSizeType left, AgentVmSizeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AgentVmSizeType"/> values are not the same. </summary>
        public static bool operator !=(AgentVmSizeType left, AgentVmSizeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AgentVmSizeType"/>. </summary>
        public static implicit operator AgentVmSizeType(string value) => new AgentVmSizeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AgentVmSizeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AgentVmSizeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
