// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Threading;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.MachineLearningCompute.Models;

namespace Azure.ResourceManager.MachineLearningCompute.Mocking
{
    /// <summary> A class to add extension methods to TenantResource. </summary>
    public partial class MockableMachineLearningComputeTenantResource : ArmResource
    {
        private ClientDiagnostics _machineLearningComputeClientDiagnostics;
        private MachineLearningComputeRestOperations _machineLearningComputeRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableMachineLearningComputeTenantResource"/> class for mocking. </summary>
        protected MockableMachineLearningComputeTenantResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableMachineLearningComputeTenantResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableMachineLearningComputeTenantResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics MachineLearningComputeClientDiagnostics => _machineLearningComputeClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.MachineLearningCompute", ProviderConstants.DefaultProviderNamespace, Diagnostics);
        private MachineLearningComputeRestOperations MachineLearningComputeRestClient => _machineLearningComputeRestClient ??= new MachineLearningComputeRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets all available operations.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.MachineLearningCompute/operations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>MachineLearningCompute_ListAvailableOperations</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ResourceOperation"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ResourceOperation> GetAvailableOperationsMachineLearningComputesAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => MachineLearningComputeRestClient.CreateListAvailableOperationsRequest();
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => ResourceOperation.DeserializeResourceOperation(e), MachineLearningComputeClientDiagnostics, Pipeline, "MockableMachineLearningComputeTenantResource.GetAvailableOperationsMachineLearningComputes", "value", null, cancellationToken);
        }

        /// <summary>
        /// Gets all available operations.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.MachineLearningCompute/operations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>MachineLearningCompute_ListAvailableOperations</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ResourceOperation"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ResourceOperation> GetAvailableOperationsMachineLearningComputes(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => MachineLearningComputeRestClient.CreateListAvailableOperationsRequest();
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => ResourceOperation.DeserializeResourceOperation(e), MachineLearningComputeClientDiagnostics, Pipeline, "MockableMachineLearningComputeTenantResource.GetAvailableOperationsMachineLearningComputes", "value", null, cancellationToken);
        }
    }
}
