// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.MachineLearningCompute.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.MachineLearningCompute.Samples
{
    public partial class Sample_OperationalizationClusterResource
    {
        // GET Operationalization Cluster
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GETOperationalizationCluster()
        {
            // Generated from example definition: specification/machinelearningcompute/resource-manager/Microsoft.MachineLearningCompute/preview/2017-08-01-preview/examples/OperationalizationClusters_Get.json
            // this example is just showing the usage of "OperationalizationClusters_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this OperationalizationClusterResource created on azure
            // for more information of creating OperationalizationClusterResource, please refer to the document of OperationalizationClusterResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string clusterName = "myCluster";
            ResourceIdentifier operationalizationClusterResourceId = OperationalizationClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName);
            OperationalizationClusterResource operationalizationCluster = client.GetOperationalizationClusterResource(operationalizationClusterResourceId);

            // invoke the operation
            OperationalizationClusterResource result = await operationalizationCluster.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            OperationalizationClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PATCH Operationalization Cluster
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PATCHOperationalizationCluster()
        {
            // Generated from example definition: specification/machinelearningcompute/resource-manager/Microsoft.MachineLearningCompute/preview/2017-08-01-preview/examples/OperationalizationClusters_Update.json
            // this example is just showing the usage of "OperationalizationClusters_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this OperationalizationClusterResource created on azure
            // for more information of creating OperationalizationClusterResource, please refer to the document of OperationalizationClusterResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string clusterName = "myCluster";
            ResourceIdentifier operationalizationClusterResourceId = OperationalizationClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName);
            OperationalizationClusterResource operationalizationCluster = client.GetOperationalizationClusterResource(operationalizationClusterResourceId);

            // invoke the operation
            OperationalizationClusterPatch patch = new OperationalizationClusterPatch()
            {
                Tags =
{
["key1"] = "value1",
},
            };
            OperationalizationClusterResource result = await operationalizationCluster.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            OperationalizationClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // DELETE Operationalization Cluster
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DELETEOperationalizationCluster()
        {
            // Generated from example definition: specification/machinelearningcompute/resource-manager/Microsoft.MachineLearningCompute/preview/2017-08-01-preview/examples/OperationalizationClusters_Delete.json
            // this example is just showing the usage of "OperationalizationClusters_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this OperationalizationClusterResource created on azure
            // for more information of creating OperationalizationClusterResource, please refer to the document of OperationalizationClusterResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string clusterName = "myCluster";
            ResourceIdentifier operationalizationClusterResourceId = OperationalizationClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName);
            OperationalizationClusterResource operationalizationCluster = client.GetOperationalizationClusterResource(operationalizationClusterResourceId);

            // invoke the operation
            await operationalizationCluster.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // List Keys of an Operationalization Cluster
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetKeys_ListKeysOfAnOperationalizationCluster()
        {
            // Generated from example definition: specification/machinelearningcompute/resource-manager/Microsoft.MachineLearningCompute/preview/2017-08-01-preview/examples/OperationalizationClusters_ListKeys.json
            // this example is just showing the usage of "OperationalizationClusters_ListKeys" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this OperationalizationClusterResource created on azure
            // for more information of creating OperationalizationClusterResource, please refer to the document of OperationalizationClusterResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string clusterName = "myCluster";
            ResourceIdentifier operationalizationClusterResourceId = OperationalizationClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName);
            OperationalizationClusterResource operationalizationCluster = client.GetOperationalizationClusterResource(operationalizationClusterResourceId);

            // invoke the operation
            OperationalizationClusterCredentials result = await operationalizationCluster.GetKeysAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Check Update for an Operationalization Cluster
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CheckSystemServicesUpdatesAvailable_CheckUpdateForAnOperationalizationCluster()
        {
            // Generated from example definition: specification/machinelearningcompute/resource-manager/Microsoft.MachineLearningCompute/preview/2017-08-01-preview/examples/OperationalizationClusters_CheckSystemServicesUpdatesAvailable.json
            // this example is just showing the usage of "OperationalizationClusters_CheckSystemServicesUpdatesAvailable" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this OperationalizationClusterResource created on azure
            // for more information of creating OperationalizationClusterResource, please refer to the document of OperationalizationClusterResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string clusterName = "myCluster";
            ResourceIdentifier operationalizationClusterResourceId = OperationalizationClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName);
            OperationalizationClusterResource operationalizationCluster = client.GetOperationalizationClusterResource(operationalizationClusterResourceId);

            // invoke the operation
            CheckSystemServicesUpdatesAvailableResponse result = await operationalizationCluster.CheckSystemServicesUpdatesAvailableAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Update System Services in an Operationalization Cluster
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task UpdateSystemServices_UpdateSystemServicesInAnOperationalizationCluster()
        {
            // Generated from example definition: specification/machinelearningcompute/resource-manager/Microsoft.MachineLearningCompute/preview/2017-08-01-preview/examples/OperationalizationClusters_UpdateSystemServices.json
            // this example is just showing the usage of "OperationalizationClusters_UpdateSystemServices" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this OperationalizationClusterResource created on azure
            // for more information of creating OperationalizationClusterResource, please refer to the document of OperationalizationClusterResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string clusterName = "myCluster";
            ResourceIdentifier operationalizationClusterResourceId = OperationalizationClusterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName);
            OperationalizationClusterResource operationalizationCluster = client.GetOperationalizationClusterResource(operationalizationClusterResourceId);

            // invoke the operation
            ArmOperation<UpdateSystemServicesResponse> lro = await operationalizationCluster.UpdateSystemServicesAsync(WaitUntil.Completed);
            UpdateSystemServicesResponse result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // List Operationalization Clusters by Subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetOperationalizationClusters_ListOperationalizationClustersBySubscription()
        {
            // Generated from example definition: specification/machinelearningcompute/resource-manager/Microsoft.MachineLearningCompute/preview/2017-08-01-preview/examples/OperationalizationClusters_ListBySubscription.json
            // this example is just showing the usage of "OperationalizationClusters_ListBySubscriptionId" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (OperationalizationClusterResource item in subscriptionResource.GetOperationalizationClustersAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                OperationalizationClusterData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
