// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The x12 time format. </summary>
    public readonly partial struct X12TimeFormat : IEquatable<X12TimeFormat>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="X12TimeFormat"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public X12TimeFormat(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string HhmmValue = "HHMM";
        private const string HhmmssValue = "HHMMSS";
        private const string HhmmsSddValue = "HHMMSSdd";
        private const string HhmmsSdValue = "HHMMSSd";

        /// <summary> NotSpecified. </summary>
        public static X12TimeFormat NotSpecified { get; } = new X12TimeFormat(NotSpecifiedValue);
        /// <summary> HHMM. </summary>
        public static X12TimeFormat Hhmm { get; } = new X12TimeFormat(HhmmValue);
        /// <summary> HHMMSS. </summary>
        public static X12TimeFormat Hhmmss { get; } = new X12TimeFormat(HhmmssValue);
        /// <summary> HHMMSSdd. </summary>
        public static X12TimeFormat HhmmsSdd { get; } = new X12TimeFormat(HhmmsSddValue);
        /// <summary> HHMMSSd. </summary>
        public static X12TimeFormat HhmmsSd { get; } = new X12TimeFormat(HhmmsSdValue);
        /// <summary> Determines if two <see cref="X12TimeFormat"/> values are the same. </summary>
        public static bool operator ==(X12TimeFormat left, X12TimeFormat right) => left.Equals(right);
        /// <summary> Determines if two <see cref="X12TimeFormat"/> values are not the same. </summary>
        public static bool operator !=(X12TimeFormat left, X12TimeFormat right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="X12TimeFormat"/>. </summary>
        public static implicit operator X12TimeFormat(string value) => new X12TimeFormat(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is X12TimeFormat other && Equals(other);
        /// <inheritdoc />
        public bool Equals(X12TimeFormat other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
