// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Logic.Models
{
    public partial class X12SecuritySettings : IUtf8JsonSerializable, IJsonModel<X12SecuritySettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<X12SecuritySettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<X12SecuritySettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<X12SecuritySettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(X12SecuritySettings)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("authorizationQualifier"u8);
            writer.WriteStringValue(AuthorizationQualifier);
            if (Optional.IsDefined(AuthorizationValue))
            {
                writer.WritePropertyName("authorizationValue"u8);
                writer.WriteStringValue(AuthorizationValue);
            }
            writer.WritePropertyName("securityQualifier"u8);
            writer.WriteStringValue(SecurityQualifier);
            if (Optional.IsDefined(PasswordValue))
            {
                writer.WritePropertyName("passwordValue"u8);
                writer.WriteStringValue(PasswordValue);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        X12SecuritySettings IJsonModel<X12SecuritySettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<X12SecuritySettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(X12SecuritySettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeX12SecuritySettings(document.RootElement, options);
        }

        internal static X12SecuritySettings DeserializeX12SecuritySettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string authorizationQualifier = default;
            string authorizationValue = default;
            string securityQualifier = default;
            string passwordValue = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("authorizationQualifier"u8))
                {
                    authorizationQualifier = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("authorizationValue"u8))
                {
                    authorizationValue = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("securityQualifier"u8))
                {
                    securityQualifier = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("passwordValue"u8))
                {
                    passwordValue = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new X12SecuritySettings(authorizationQualifier, authorizationValue, securityQualifier, passwordValue, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<X12SecuritySettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<X12SecuritySettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(X12SecuritySettings)} does not support writing '{options.Format}' format.");
            }
        }

        X12SecuritySettings IPersistableModel<X12SecuritySettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<X12SecuritySettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeX12SecuritySettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(X12SecuritySettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<X12SecuritySettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
