// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Logic.Models
{
    public partial class X12AcknowledgementSettings : IUtf8JsonSerializable, IJsonModel<X12AcknowledgementSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<X12AcknowledgementSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<X12AcknowledgementSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<X12AcknowledgementSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(X12AcknowledgementSettings)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("needTechnicalAcknowledgement"u8);
            writer.WriteBooleanValue(NeedTechnicalAcknowledgement);
            writer.WritePropertyName("batchTechnicalAcknowledgements"u8);
            writer.WriteBooleanValue(BatchTechnicalAcknowledgement);
            writer.WritePropertyName("needFunctionalAcknowledgement"u8);
            writer.WriteBooleanValue(NeedFunctionalAcknowledgement);
            if (Optional.IsDefined(FunctionalAcknowledgementVersion))
            {
                writer.WritePropertyName("functionalAcknowledgementVersion"u8);
                writer.WriteStringValue(FunctionalAcknowledgementVersion);
            }
            writer.WritePropertyName("batchFunctionalAcknowledgements"u8);
            writer.WriteBooleanValue(BatchFunctionalAcknowledgement);
            writer.WritePropertyName("needImplementationAcknowledgement"u8);
            writer.WriteBooleanValue(NeedImplementationAcknowledgement);
            if (Optional.IsDefined(ImplementationAcknowledgementVersion))
            {
                writer.WritePropertyName("implementationAcknowledgementVersion"u8);
                writer.WriteStringValue(ImplementationAcknowledgementVersion);
            }
            writer.WritePropertyName("batchImplementationAcknowledgements"u8);
            writer.WriteBooleanValue(BatchImplementationAcknowledgement);
            writer.WritePropertyName("needLoopForValidMessages"u8);
            writer.WriteBooleanValue(NeedLoopForValidMessages);
            writer.WritePropertyName("sendSynchronousAcknowledgement"u8);
            writer.WriteBooleanValue(SendSynchronousAcknowledgement);
            if (Optional.IsDefined(AcknowledgementControlNumberPrefix))
            {
                writer.WritePropertyName("acknowledgementControlNumberPrefix"u8);
                writer.WriteStringValue(AcknowledgementControlNumberPrefix);
            }
            if (Optional.IsDefined(AcknowledgementControlNumberSuffix))
            {
                writer.WritePropertyName("acknowledgementControlNumberSuffix"u8);
                writer.WriteStringValue(AcknowledgementControlNumberSuffix);
            }
            writer.WritePropertyName("acknowledgementControlNumberLowerBound"u8);
            writer.WriteNumberValue(AcknowledgementControlNumberLowerBound);
            writer.WritePropertyName("acknowledgementControlNumberUpperBound"u8);
            writer.WriteNumberValue(AcknowledgementControlNumberUpperBound);
            writer.WritePropertyName("rolloverAcknowledgementControlNumber"u8);
            writer.WriteBooleanValue(RolloverAcknowledgementControlNumber);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        X12AcknowledgementSettings IJsonModel<X12AcknowledgementSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<X12AcknowledgementSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(X12AcknowledgementSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeX12AcknowledgementSettings(document.RootElement, options);
        }

        internal static X12AcknowledgementSettings DeserializeX12AcknowledgementSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool needTechnicalAcknowledgement = default;
            bool batchTechnicalAcknowledgements = default;
            bool needFunctionalAcknowledgement = default;
            string functionalAcknowledgementVersion = default;
            bool batchFunctionalAcknowledgements = default;
            bool needImplementationAcknowledgement = default;
            string implementationAcknowledgementVersion = default;
            bool batchImplementationAcknowledgements = default;
            bool needLoopForValidMessages = default;
            bool sendSynchronousAcknowledgement = default;
            string acknowledgementControlNumberPrefix = default;
            string acknowledgementControlNumberSuffix = default;
            int acknowledgementControlNumberLowerBound = default;
            int acknowledgementControlNumberUpperBound = default;
            bool rolloverAcknowledgementControlNumber = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("needTechnicalAcknowledgement"u8))
                {
                    needTechnicalAcknowledgement = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("batchTechnicalAcknowledgements"u8))
                {
                    batchTechnicalAcknowledgements = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("needFunctionalAcknowledgement"u8))
                {
                    needFunctionalAcknowledgement = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("functionalAcknowledgementVersion"u8))
                {
                    functionalAcknowledgementVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("batchFunctionalAcknowledgements"u8))
                {
                    batchFunctionalAcknowledgements = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("needImplementationAcknowledgement"u8))
                {
                    needImplementationAcknowledgement = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("implementationAcknowledgementVersion"u8))
                {
                    implementationAcknowledgementVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("batchImplementationAcknowledgements"u8))
                {
                    batchImplementationAcknowledgements = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("needLoopForValidMessages"u8))
                {
                    needLoopForValidMessages = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("sendSynchronousAcknowledgement"u8))
                {
                    sendSynchronousAcknowledgement = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("acknowledgementControlNumberPrefix"u8))
                {
                    acknowledgementControlNumberPrefix = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("acknowledgementControlNumberSuffix"u8))
                {
                    acknowledgementControlNumberSuffix = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("acknowledgementControlNumberLowerBound"u8))
                {
                    acknowledgementControlNumberLowerBound = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("acknowledgementControlNumberUpperBound"u8))
                {
                    acknowledgementControlNumberUpperBound = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("rolloverAcknowledgementControlNumber"u8))
                {
                    rolloverAcknowledgementControlNumber = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new X12AcknowledgementSettings(
                needTechnicalAcknowledgement,
                batchTechnicalAcknowledgements,
                needFunctionalAcknowledgement,
                functionalAcknowledgementVersion,
                batchFunctionalAcknowledgements,
                needImplementationAcknowledgement,
                implementationAcknowledgementVersion,
                batchImplementationAcknowledgements,
                needLoopForValidMessages,
                sendSynchronousAcknowledgement,
                acknowledgementControlNumberPrefix,
                acknowledgementControlNumberSuffix,
                acknowledgementControlNumberLowerBound,
                acknowledgementControlNumberUpperBound,
                rolloverAcknowledgementControlNumber,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<X12AcknowledgementSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<X12AcknowledgementSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(X12AcknowledgementSettings)} does not support writing '{options.Format}' format.");
            }
        }

        X12AcknowledgementSettings IPersistableModel<X12AcknowledgementSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<X12AcknowledgementSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeX12AcknowledgementSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(X12AcknowledgementSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<X12AcknowledgementSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
