// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The usage indicator. </summary>
    public readonly partial struct UsageIndicator : IEquatable<UsageIndicator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UsageIndicator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UsageIndicator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string TestValue = "Test";
        private const string InformationValue = "Information";
        private const string ProductionValue = "Production";

        /// <summary> NotSpecified. </summary>
        public static UsageIndicator NotSpecified { get; } = new UsageIndicator(NotSpecifiedValue);
        /// <summary> Test. </summary>
        public static UsageIndicator Test { get; } = new UsageIndicator(TestValue);
        /// <summary> Information. </summary>
        public static UsageIndicator Information { get; } = new UsageIndicator(InformationValue);
        /// <summary> Production. </summary>
        public static UsageIndicator Production { get; } = new UsageIndicator(ProductionValue);
        /// <summary> Determines if two <see cref="UsageIndicator"/> values are the same. </summary>
        public static bool operator ==(UsageIndicator left, UsageIndicator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UsageIndicator"/> values are not the same. </summary>
        public static bool operator !=(UsageIndicator left, UsageIndicator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UsageIndicator"/>. </summary>
        public static implicit operator UsageIndicator(string value) => new UsageIndicator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UsageIndicator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UsageIndicator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
