// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The trailing separator policy. </summary>
    public readonly partial struct TrailingSeparatorPolicy : IEquatable<TrailingSeparatorPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TrailingSeparatorPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TrailingSeparatorPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string NotAllowedValue = "NotAllowed";
        private const string OptionalValue = "Optional";
        private const string MandatoryValue = "Mandatory";

        /// <summary> NotSpecified. </summary>
        public static TrailingSeparatorPolicy NotSpecified { get; } = new TrailingSeparatorPolicy(NotSpecifiedValue);
        /// <summary> NotAllowed. </summary>
        public static TrailingSeparatorPolicy NotAllowed { get; } = new TrailingSeparatorPolicy(NotAllowedValue);
        /// <summary> Optional. </summary>
        public static TrailingSeparatorPolicy Optional { get; } = new TrailingSeparatorPolicy(OptionalValue);
        /// <summary> Mandatory. </summary>
        public static TrailingSeparatorPolicy Mandatory { get; } = new TrailingSeparatorPolicy(MandatoryValue);
        /// <summary> Determines if two <see cref="TrailingSeparatorPolicy"/> values are the same. </summary>
        public static bool operator ==(TrailingSeparatorPolicy left, TrailingSeparatorPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TrailingSeparatorPolicy"/> values are not the same. </summary>
        public static bool operator !=(TrailingSeparatorPolicy left, TrailingSeparatorPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TrailingSeparatorPolicy"/>. </summary>
        public static implicit operator TrailingSeparatorPolicy(string value) => new TrailingSeparatorPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TrailingSeparatorPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TrailingSeparatorPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
