// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The Swagger XML. </summary>
    public partial class SwaggerXml
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SwaggerXml"/>. </summary>
        public SwaggerXml()
        {
            Extensions = new ChangeTrackingDictionary<string, BinaryData>();
        }

        /// <summary> Initializes a new instance of <see cref="SwaggerXml"/>. </summary>
        /// <param name="name"> The xml element or attribute name. </param>
        /// <param name="namespace"> The xml namespace. </param>
        /// <param name="prefix"> The name prefix. </param>
        /// <param name="isAttribute"> Indicates whether the property should be an attribute instead of an element. </param>
        /// <param name="isWrapped"> Indicates whether the array elements are wrapped in a container element. </param>
        /// <param name="extensions"> The vendor extensions. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SwaggerXml(string name, string @namespace, string prefix, bool? isAttribute, bool? isWrapped, IDictionary<string, BinaryData> extensions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Namespace = @namespace;
            Prefix = prefix;
            IsAttribute = isAttribute;
            IsWrapped = isWrapped;
            Extensions = extensions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The xml element or attribute name. </summary>
        public string Name { get; set; }
        /// <summary> The xml namespace. </summary>
        public string Namespace { get; set; }
        /// <summary> The name prefix. </summary>
        public string Prefix { get; set; }
        /// <summary> Indicates whether the property should be an attribute instead of an element. </summary>
        public bool? IsAttribute { get; set; }
        /// <summary> Indicates whether the array elements are wrapped in a container element. </summary>
        public bool? IsWrapped { get; set; }
        /// <summary>
        /// The vendor extensions.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IDictionary<string, BinaryData> Extensions { get; }
    }
}
