// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The swagger schema type. </summary>
    public readonly partial struct SwaggerSchemaType : IEquatable<SwaggerSchemaType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SwaggerSchemaType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SwaggerSchemaType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StringValue = "String";
        private const string NumberValue = "Number";
        private const string IntegerValue = "Integer";
        private const string BooleanValue = "Boolean";
        private const string ArrayValue = "Array";
        private const string FileValue = "File";
        private const string ObjectValue = "Object";
        private const string NullValue = "Null";

        /// <summary> String. </summary>
        public static SwaggerSchemaType String { get; } = new SwaggerSchemaType(StringValue);
        /// <summary> Number. </summary>
        public static SwaggerSchemaType Number { get; } = new SwaggerSchemaType(NumberValue);
        /// <summary> Integer. </summary>
        public static SwaggerSchemaType Integer { get; } = new SwaggerSchemaType(IntegerValue);
        /// <summary> Boolean. </summary>
        public static SwaggerSchemaType Boolean { get; } = new SwaggerSchemaType(BooleanValue);
        /// <summary> Array. </summary>
        public static SwaggerSchemaType Array { get; } = new SwaggerSchemaType(ArrayValue);
        /// <summary> File. </summary>
        public static SwaggerSchemaType File { get; } = new SwaggerSchemaType(FileValue);
        /// <summary> Object. </summary>
        public static SwaggerSchemaType Object { get; } = new SwaggerSchemaType(ObjectValue);
        /// <summary> Null. </summary>
        public static SwaggerSchemaType Null { get; } = new SwaggerSchemaType(NullValue);
        /// <summary> Determines if two <see cref="SwaggerSchemaType"/> values are the same. </summary>
        public static bool operator ==(SwaggerSchemaType left, SwaggerSchemaType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SwaggerSchemaType"/> values are not the same. </summary>
        public static bool operator !=(SwaggerSchemaType left, SwaggerSchemaType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SwaggerSchemaType"/>. </summary>
        public static implicit operator SwaggerSchemaType(string value) => new SwaggerSchemaType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SwaggerSchemaType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SwaggerSchemaType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
