// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Logic.Models
{
    public partial class SwaggerSchema : IUtf8JsonSerializable, IJsonModel<SwaggerSchema>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SwaggerSchema>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SwaggerSchema>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SwaggerSchema>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SwaggerSchema)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Reference))
            {
                writer.WritePropertyName("ref"u8);
                writer.WriteStringValue(Reference);
            }
            if (Optional.IsDefined(SchemaType))
            {
                writer.WritePropertyName("type"u8);
                writer.WriteStringValue(SchemaType.Value.ToString());
            }
            if (Optional.IsDefined(Title))
            {
                writer.WritePropertyName("title"u8);
                writer.WriteStringValue(Title);
            }
            if (Optional.IsDefined(Items))
            {
                writer.WritePropertyName("items"u8);
                writer.WriteObjectValue(Items, options);
            }
            if (Optional.IsCollectionDefined(Properties))
            {
                writer.WritePropertyName("properties"u8);
                writer.WriteStartObject();
                foreach (var item in Properties)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteObjectValue(item.Value, options);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsDefined(AdditionalProperties))
            {
                writer.WritePropertyName("additionalProperties"u8);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(AdditionalProperties);
#else
                using (JsonDocument document = JsonDocument.Parse(AdditionalProperties))
                {
                    JsonSerializer.Serialize(writer, document.RootElement);
                }
#endif
            }
            if (Optional.IsCollectionDefined(RequiredProperties))
            {
                writer.WritePropertyName("required"u8);
                writer.WriteStartArray();
                foreach (var item in RequiredProperties)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(MaxProperties))
            {
                writer.WritePropertyName("maxProperties"u8);
                writer.WriteNumberValue(MaxProperties.Value);
            }
            if (Optional.IsDefined(MinProperties))
            {
                writer.WritePropertyName("minProperties"u8);
                writer.WriteNumberValue(MinProperties.Value);
            }
            if (Optional.IsCollectionDefined(AllOf))
            {
                writer.WritePropertyName("allOf"u8);
                writer.WriteStartArray();
                foreach (var item in AllOf)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Discriminator))
            {
                writer.WritePropertyName("discriminator"u8);
                writer.WriteStringValue(Discriminator);
            }
            if (Optional.IsDefined(IsReadOnly))
            {
                writer.WritePropertyName("readOnly"u8);
                writer.WriteBooleanValue(IsReadOnly.Value);
            }
            if (Optional.IsDefined(Xml))
            {
                writer.WritePropertyName("xml"u8);
                writer.WriteObjectValue(Xml, options);
            }
            if (Optional.IsDefined(ExternalDocs))
            {
                writer.WritePropertyName("externalDocs"u8);
                writer.WriteObjectValue(ExternalDocs, options);
            }
            if (Optional.IsDefined(Example))
            {
                writer.WritePropertyName("example"u8);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(Example);
#else
                using (JsonDocument document = JsonDocument.Parse(Example))
                {
                    JsonSerializer.Serialize(writer, document.RootElement);
                }
#endif
            }
            if (Optional.IsDefined(IsNotificationUrlExtension))
            {
                writer.WritePropertyName("notificationUrlExtension"u8);
                writer.WriteBooleanValue(IsNotificationUrlExtension.Value);
            }
            if (Optional.IsDefined(DynamicSchemaOld))
            {
                writer.WritePropertyName("dynamicSchemaOld"u8);
                writer.WriteObjectValue(DynamicSchemaOld, options);
            }
            if (Optional.IsDefined(DynamicSchemaNew))
            {
                writer.WritePropertyName("dynamicSchemaNew"u8);
                writer.WriteObjectValue(DynamicSchemaNew, options);
            }
            if (Optional.IsDefined(DynamicListNew))
            {
                writer.WritePropertyName("dynamicListNew"u8);
                writer.WriteObjectValue(DynamicListNew, options);
            }
            if (Optional.IsDefined(DynamicTree))
            {
                writer.WritePropertyName("dynamicTree"u8);
                writer.WriteObjectValue(DynamicTree, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SwaggerSchema IJsonModel<SwaggerSchema>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SwaggerSchema>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SwaggerSchema)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSwaggerSchema(document.RootElement, options);
        }

        internal static SwaggerSchema DeserializeSwaggerSchema(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string @ref = default;
            SwaggerSchemaType? type = default;
            string title = default;
            SwaggerSchema items = default;
            IDictionary<string, SwaggerSchema> properties = default;
            BinaryData additionalProperties = default;
            IList<string> required = default;
            int? maxProperties = default;
            int? minProperties = default;
            IList<SwaggerSchema> allOf = default;
            string discriminator = default;
            bool? readOnly = default;
            SwaggerXml xml = default;
            SwaggerExternalDocumentation externalDocs = default;
            BinaryData example = default;
            bool? notificationUrlExtension = default;
            SwaggerCustomDynamicSchema dynamicSchemaOld = default;
            SwaggerCustomDynamicProperties dynamicSchemaNew = default;
            SwaggerCustomDynamicList dynamicListNew = default;
            SwaggerCustomDynamicTree dynamicTree = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("ref"u8))
                {
                    @ref = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    type = new SwaggerSchemaType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("title"u8))
                {
                    title = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("items"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    items = DeserializeSwaggerSchema(property.Value, options);
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, SwaggerSchema> dictionary = new Dictionary<string, SwaggerSchema>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, DeserializeSwaggerSchema(property0.Value, options));
                    }
                    properties = dictionary;
                    continue;
                }
                if (property.NameEquals("additionalProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    additionalProperties = BinaryData.FromString(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("required"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    required = array;
                    continue;
                }
                if (property.NameEquals("maxProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxProperties = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("minProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minProperties = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("allOf"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SwaggerSchema> array = new List<SwaggerSchema>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DeserializeSwaggerSchema(item, options));
                    }
                    allOf = array;
                    continue;
                }
                if (property.NameEquals("discriminator"u8))
                {
                    discriminator = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("readOnly"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    readOnly = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("xml"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    xml = SwaggerXml.DeserializeSwaggerXml(property.Value, options);
                    continue;
                }
                if (property.NameEquals("externalDocs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    externalDocs = SwaggerExternalDocumentation.DeserializeSwaggerExternalDocumentation(property.Value, options);
                    continue;
                }
                if (property.NameEquals("example"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    example = BinaryData.FromString(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("notificationUrlExtension"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    notificationUrlExtension = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("dynamicSchemaOld"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dynamicSchemaOld = SwaggerCustomDynamicSchema.DeserializeSwaggerCustomDynamicSchema(property.Value, options);
                    continue;
                }
                if (property.NameEquals("dynamicSchemaNew"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dynamicSchemaNew = SwaggerCustomDynamicProperties.DeserializeSwaggerCustomDynamicProperties(property.Value, options);
                    continue;
                }
                if (property.NameEquals("dynamicListNew"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dynamicListNew = SwaggerCustomDynamicList.DeserializeSwaggerCustomDynamicList(property.Value, options);
                    continue;
                }
                if (property.NameEquals("dynamicTree"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dynamicTree = SwaggerCustomDynamicTree.DeserializeSwaggerCustomDynamicTree(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SwaggerSchema(
                @ref,
                type,
                title,
                items,
                properties ?? new ChangeTrackingDictionary<string, SwaggerSchema>(),
                additionalProperties,
                required ?? new ChangeTrackingList<string>(),
                maxProperties,
                minProperties,
                allOf ?? new ChangeTrackingList<SwaggerSchema>(),
                discriminator,
                readOnly,
                xml,
                externalDocs,
                example,
                notificationUrlExtension,
                dynamicSchemaOld,
                dynamicSchemaNew,
                dynamicListNew,
                dynamicTree,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SwaggerSchema>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SwaggerSchema>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SwaggerSchema)} does not support writing '{options.Format}' format.");
            }
        }

        SwaggerSchema IPersistableModel<SwaggerSchema>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SwaggerSchema>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSwaggerSchema(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SwaggerSchema)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SwaggerSchema>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
