// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> Open authentication policy provider type. </summary>
    public readonly partial struct OpenAuthenticationProviderType : IEquatable<OpenAuthenticationProviderType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OpenAuthenticationProviderType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OpenAuthenticationProviderType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AADValue = "AAD";

        /// <summary> AAD. </summary>
        public static OpenAuthenticationProviderType AAD { get; } = new OpenAuthenticationProviderType(AADValue);
        /// <summary> Determines if two <see cref="OpenAuthenticationProviderType"/> values are the same. </summary>
        public static bool operator ==(OpenAuthenticationProviderType left, OpenAuthenticationProviderType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OpenAuthenticationProviderType"/> values are not the same. </summary>
        public static bool operator !=(OpenAuthenticationProviderType left, OpenAuthenticationProviderType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OpenAuthenticationProviderType"/>. </summary>
        public static implicit operator OpenAuthenticationProviderType(string value) => new OpenAuthenticationProviderType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OpenAuthenticationProviderType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OpenAuthenticationProviderType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
