// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The WSDL service. </summary>
    public partial class LogicWsdlService
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LogicWsdlService"/>. </summary>
        internal LogicWsdlService()
        {
            EndpointQualifiedNames = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="LogicWsdlService"/>. </summary>
        /// <param name="qualifiedName"> The qualified name. </param>
        /// <param name="endpointQualifiedNames"> The list of endpoints' qualified names. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LogicWsdlService(string qualifiedName, IReadOnlyList<string> endpointQualifiedNames, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            QualifiedName = qualifiedName;
            EndpointQualifiedNames = endpointQualifiedNames;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The qualified name. </summary>
        public string QualifiedName { get; }
        /// <summary> The list of endpoints' qualified names. </summary>
        public IReadOnlyList<string> EndpointQualifiedNames { get; }
    }
}
