// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The WSDL import method. </summary>
    public readonly partial struct LogicWsdlImportMethod : IEquatable<LogicWsdlImportMethod>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LogicWsdlImportMethod"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LogicWsdlImportMethod(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string SoapToRestValue = "SoapToRest";
        private const string SoapPassThroughValue = "SoapPassThrough";

        /// <summary> NotSpecified. </summary>
        public static LogicWsdlImportMethod NotSpecified { get; } = new LogicWsdlImportMethod(NotSpecifiedValue);
        /// <summary> SoapToRest. </summary>
        public static LogicWsdlImportMethod SoapToRest { get; } = new LogicWsdlImportMethod(SoapToRestValue);
        /// <summary> SoapPassThrough. </summary>
        public static LogicWsdlImportMethod SoapPassThrough { get; } = new LogicWsdlImportMethod(SoapPassThroughValue);
        /// <summary> Determines if two <see cref="LogicWsdlImportMethod"/> values are the same. </summary>
        public static bool operator ==(LogicWsdlImportMethod left, LogicWsdlImportMethod right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LogicWsdlImportMethod"/> values are not the same. </summary>
        public static bool operator !=(LogicWsdlImportMethod left, LogicWsdlImportMethod right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LogicWsdlImportMethod"/>. </summary>
        public static implicit operator LogicWsdlImportMethod(string value) => new LogicWsdlImportMethod(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LogicWsdlImportMethod other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LogicWsdlImportMethod other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
