// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The workflow trigger reference. </summary>
    public partial class LogicWorkflowTriggerReference : LogicResourceReference
    {
        /// <summary> Initializes a new instance of <see cref="LogicWorkflowTriggerReference"/>. </summary>
        public LogicWorkflowTriggerReference()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LogicWorkflowTriggerReference"/>. </summary>
        /// <param name="id"> The resource id. </param>
        /// <param name="name"> Gets the resource name. </param>
        /// <param name="resourceType"> Gets the resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="flowName"> The workflow name. </param>
        /// <param name="triggerName"> The workflow trigger name. </param>
        internal LogicWorkflowTriggerReference(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string flowName, string triggerName) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            FlowName = flowName;
            TriggerName = triggerName;
        }

        /// <summary> The workflow name. </summary>
        public string FlowName { get; set; }
        /// <summary> The workflow trigger name. </summary>
        public string TriggerName { get; set; }
    }
}
