// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The workflow trigger provisioning state. </summary>
    public readonly partial struct LogicWorkflowTriggerProvisioningState : IEquatable<LogicWorkflowTriggerProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LogicWorkflowTriggerProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LogicWorkflowTriggerProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string AcceptedValue = "Accepted";
        private const string RunningValue = "Running";
        private const string ReadyValue = "Ready";
        private const string CreatingValue = "Creating";
        private const string CreatedValue = "Created";
        private const string DeletingValue = "Deleting";
        private const string DeletedValue = "Deleted";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";
        private const string MovingValue = "Moving";
        private const string UpdatingValue = "Updating";
        private const string RegisteringValue = "Registering";
        private const string RegisteredValue = "Registered";
        private const string UnregisteringValue = "Unregistering";
        private const string UnregisteredValue = "Unregistered";
        private const string CompletedValue = "Completed";

        /// <summary> NotSpecified. </summary>
        public static LogicWorkflowTriggerProvisioningState NotSpecified { get; } = new LogicWorkflowTriggerProvisioningState(NotSpecifiedValue);
        /// <summary> Accepted. </summary>
        public static LogicWorkflowTriggerProvisioningState Accepted { get; } = new LogicWorkflowTriggerProvisioningState(AcceptedValue);
        /// <summary> Running. </summary>
        public static LogicWorkflowTriggerProvisioningState Running { get; } = new LogicWorkflowTriggerProvisioningState(RunningValue);
        /// <summary> Ready. </summary>
        public static LogicWorkflowTriggerProvisioningState Ready { get; } = new LogicWorkflowTriggerProvisioningState(ReadyValue);
        /// <summary> Creating. </summary>
        public static LogicWorkflowTriggerProvisioningState Creating { get; } = new LogicWorkflowTriggerProvisioningState(CreatingValue);
        /// <summary> Created. </summary>
        public static LogicWorkflowTriggerProvisioningState Created { get; } = new LogicWorkflowTriggerProvisioningState(CreatedValue);
        /// <summary> Deleting. </summary>
        public static LogicWorkflowTriggerProvisioningState Deleting { get; } = new LogicWorkflowTriggerProvisioningState(DeletingValue);
        /// <summary> Deleted. </summary>
        public static LogicWorkflowTriggerProvisioningState Deleted { get; } = new LogicWorkflowTriggerProvisioningState(DeletedValue);
        /// <summary> Canceled. </summary>
        public static LogicWorkflowTriggerProvisioningState Canceled { get; } = new LogicWorkflowTriggerProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static LogicWorkflowTriggerProvisioningState Failed { get; } = new LogicWorkflowTriggerProvisioningState(FailedValue);
        /// <summary> Succeeded. </summary>
        public static LogicWorkflowTriggerProvisioningState Succeeded { get; } = new LogicWorkflowTriggerProvisioningState(SucceededValue);
        /// <summary> Moving. </summary>
        public static LogicWorkflowTriggerProvisioningState Moving { get; } = new LogicWorkflowTriggerProvisioningState(MovingValue);
        /// <summary> Updating. </summary>
        public static LogicWorkflowTriggerProvisioningState Updating { get; } = new LogicWorkflowTriggerProvisioningState(UpdatingValue);
        /// <summary> Registering. </summary>
        public static LogicWorkflowTriggerProvisioningState Registering { get; } = new LogicWorkflowTriggerProvisioningState(RegisteringValue);
        /// <summary> Registered. </summary>
        public static LogicWorkflowTriggerProvisioningState Registered { get; } = new LogicWorkflowTriggerProvisioningState(RegisteredValue);
        /// <summary> Unregistering. </summary>
        public static LogicWorkflowTriggerProvisioningState Unregistering { get; } = new LogicWorkflowTriggerProvisioningState(UnregisteringValue);
        /// <summary> Unregistered. </summary>
        public static LogicWorkflowTriggerProvisioningState Unregistered { get; } = new LogicWorkflowTriggerProvisioningState(UnregisteredValue);
        /// <summary> Completed. </summary>
        public static LogicWorkflowTriggerProvisioningState Completed { get; } = new LogicWorkflowTriggerProvisioningState(CompletedValue);
        /// <summary> Determines if two <see cref="LogicWorkflowTriggerProvisioningState"/> values are the same. </summary>
        public static bool operator ==(LogicWorkflowTriggerProvisioningState left, LogicWorkflowTriggerProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LogicWorkflowTriggerProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(LogicWorkflowTriggerProvisioningState left, LogicWorkflowTriggerProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LogicWorkflowTriggerProvisioningState"/>. </summary>
        public static implicit operator LogicWorkflowTriggerProvisioningState(string value) => new LogicWorkflowTriggerProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LogicWorkflowTriggerProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LogicWorkflowTriggerProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
