// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The workflow trigger callback URL. </summary>
    public partial class LogicWorkflowTriggerCallbackUri
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LogicWorkflowTriggerCallbackUri"/>. </summary>
        internal LogicWorkflowTriggerCallbackUri()
        {
            RelativePathParameters = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="LogicWorkflowTriggerCallbackUri"/>. </summary>
        /// <param name="value"> Gets the workflow trigger callback URL. </param>
        /// <param name="method"> Gets the workflow trigger callback URL HTTP method. </param>
        /// <param name="basePath"> Gets the workflow trigger callback URL base path. </param>
        /// <param name="relativePath"> Gets the workflow trigger callback URL relative path. </param>
        /// <param name="relativePathParameters"> Gets the workflow trigger callback URL relative path parameters. </param>
        /// <param name="queries"> Gets the workflow trigger callback URL query parameters. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LogicWorkflowTriggerCallbackUri(string value, RequestMethod? method, string basePath, string relativePath, IReadOnlyList<string> relativePathParameters, LogicWorkflowTriggerCallbackQueryParameterInfo queries, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            Method = method;
            BasePath = basePath;
            RelativePath = relativePath;
            RelativePathParameters = relativePathParameters;
            Queries = queries;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the workflow trigger callback URL. </summary>
        public string Value { get; }
        /// <summary> Gets the workflow trigger callback URL HTTP method. </summary>
        public RequestMethod? Method { get; }
        /// <summary> Gets the workflow trigger callback URL base path. </summary>
        public string BasePath { get; }
        /// <summary> Gets the workflow trigger callback URL relative path. </summary>
        public string RelativePath { get; }
        /// <summary> Gets the workflow trigger callback URL relative path parameters. </summary>
        public IReadOnlyList<string> RelativePathParameters { get; }
        /// <summary> Gets the workflow trigger callback URL query parameters. </summary>
        public LogicWorkflowTriggerCallbackQueryParameterInfo Queries { get; }
    }
}
