// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> Gets the workflow trigger callback URL query parameters. </summary>
    public partial class LogicWorkflowTriggerCallbackQueryParameterInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LogicWorkflowTriggerCallbackQueryParameterInfo"/>. </summary>
        internal LogicWorkflowTriggerCallbackQueryParameterInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LogicWorkflowTriggerCallbackQueryParameterInfo"/>. </summary>
        /// <param name="apiVersion"> The api version. </param>
        /// <param name="sp"> The SAS permissions. </param>
        /// <param name="sv"> The SAS version. </param>
        /// <param name="sig"> The SAS signature. </param>
        /// <param name="se"> The SAS timestamp. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LogicWorkflowTriggerCallbackQueryParameterInfo(string apiVersion, string sp, string sv, string sig, string se, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ApiVersion = apiVersion;
            Sp = sp;
            Sv = sv;
            Sig = sig;
            Se = se;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The api version. </summary>
        public string ApiVersion { get; }
        /// <summary> The SAS permissions. </summary>
        public string Sp { get; }
        /// <summary> The SAS version. </summary>
        public string Sv { get; }
        /// <summary> The SAS signature. </summary>
        public string Sig { get; }
        /// <summary> The SAS timestamp. </summary>
        public string Se { get; }
    }
}
