// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The workflow state. </summary>
    public readonly partial struct LogicWorkflowState : IEquatable<LogicWorkflowState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LogicWorkflowState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LogicWorkflowState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string CompletedValue = "Completed";
        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";
        private const string DeletedValue = "Deleted";
        private const string SuspendedValue = "Suspended";

        /// <summary> NotSpecified. </summary>
        public static LogicWorkflowState NotSpecified { get; } = new LogicWorkflowState(NotSpecifiedValue);
        /// <summary> Completed. </summary>
        public static LogicWorkflowState Completed { get; } = new LogicWorkflowState(CompletedValue);
        /// <summary> Enabled. </summary>
        public static LogicWorkflowState Enabled { get; } = new LogicWorkflowState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static LogicWorkflowState Disabled { get; } = new LogicWorkflowState(DisabledValue);
        /// <summary> Deleted. </summary>
        public static LogicWorkflowState Deleted { get; } = new LogicWorkflowState(DeletedValue);
        /// <summary> Suspended. </summary>
        public static LogicWorkflowState Suspended { get; } = new LogicWorkflowState(SuspendedValue);
        /// <summary> Determines if two <see cref="LogicWorkflowState"/> values are the same. </summary>
        public static bool operator ==(LogicWorkflowState left, LogicWorkflowState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LogicWorkflowState"/> values are not the same. </summary>
        public static bool operator !=(LogicWorkflowState left, LogicWorkflowState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LogicWorkflowState"/>. </summary>
        public static implicit operator LogicWorkflowState(string value) => new LogicWorkflowState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LogicWorkflowState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LogicWorkflowState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
