// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The request history. </summary>
    public partial class LogicWorkflowRequestHistoryProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LogicWorkflowRequestHistoryProperties"/>. </summary>
        public LogicWorkflowRequestHistoryProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LogicWorkflowRequestHistoryProperties"/>. </summary>
        /// <param name="startOn"> The time the request started. </param>
        /// <param name="endOn"> The time the request ended. </param>
        /// <param name="request"> The request. </param>
        /// <param name="response"> The response. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LogicWorkflowRequestHistoryProperties(DateTimeOffset? startOn, DateTimeOffset? endOn, LogicWorkflowRequest request, LogicWorkflowResponse response, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StartOn = startOn;
            EndOn = endOn;
            Request = request;
            Response = response;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The time the request started. </summary>
        public DateTimeOffset? StartOn { get; set; }
        /// <summary> The time the request ended. </summary>
        public DateTimeOffset? EndOn { get; set; }
        /// <summary> The request. </summary>
        public LogicWorkflowRequest Request { get; set; }
        /// <summary> The response. </summary>
        public LogicWorkflowResponse Response { get; set; }
    }
}
