// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The recurrence frequency. </summary>
    public readonly partial struct LogicWorkflowRecurrenceFrequency : IEquatable<LogicWorkflowRecurrenceFrequency>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LogicWorkflowRecurrenceFrequency"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LogicWorkflowRecurrenceFrequency(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string SecondValue = "Second";
        private const string MinuteValue = "Minute";
        private const string HourValue = "Hour";
        private const string DayValue = "Day";
        private const string WeekValue = "Week";
        private const string MonthValue = "Month";
        private const string YearValue = "Year";

        /// <summary> NotSpecified. </summary>
        public static LogicWorkflowRecurrenceFrequency NotSpecified { get; } = new LogicWorkflowRecurrenceFrequency(NotSpecifiedValue);
        /// <summary> Second. </summary>
        public static LogicWorkflowRecurrenceFrequency Second { get; } = new LogicWorkflowRecurrenceFrequency(SecondValue);
        /// <summary> Minute. </summary>
        public static LogicWorkflowRecurrenceFrequency Minute { get; } = new LogicWorkflowRecurrenceFrequency(MinuteValue);
        /// <summary> Hour. </summary>
        public static LogicWorkflowRecurrenceFrequency Hour { get; } = new LogicWorkflowRecurrenceFrequency(HourValue);
        /// <summary> Day. </summary>
        public static LogicWorkflowRecurrenceFrequency Day { get; } = new LogicWorkflowRecurrenceFrequency(DayValue);
        /// <summary> Week. </summary>
        public static LogicWorkflowRecurrenceFrequency Week { get; } = new LogicWorkflowRecurrenceFrequency(WeekValue);
        /// <summary> Month. </summary>
        public static LogicWorkflowRecurrenceFrequency Month { get; } = new LogicWorkflowRecurrenceFrequency(MonthValue);
        /// <summary> Year. </summary>
        public static LogicWorkflowRecurrenceFrequency Year { get; } = new LogicWorkflowRecurrenceFrequency(YearValue);
        /// <summary> Determines if two <see cref="LogicWorkflowRecurrenceFrequency"/> values are the same. </summary>
        public static bool operator ==(LogicWorkflowRecurrenceFrequency left, LogicWorkflowRecurrenceFrequency right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LogicWorkflowRecurrenceFrequency"/> values are not the same. </summary>
        public static bool operator !=(LogicWorkflowRecurrenceFrequency left, LogicWorkflowRecurrenceFrequency right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LogicWorkflowRecurrenceFrequency"/>. </summary>
        public static implicit operator LogicWorkflowRecurrenceFrequency(string value) => new LogicWorkflowRecurrenceFrequency(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LogicWorkflowRecurrenceFrequency other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LogicWorkflowRecurrenceFrequency other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
