// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The parameter type. </summary>
    public readonly partial struct LogicWorkflowParameterType : IEquatable<LogicWorkflowParameterType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LogicWorkflowParameterType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LogicWorkflowParameterType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string StringValue = "String";
        private const string SecureStringValue = "SecureString";
        private const string IntValue = "Int";
        private const string FloatValue = "Float";
        private const string BoolValue = "Bool";
        private const string ArrayValue = "Array";
        private const string ObjectValue = "Object";
        private const string SecureObjectValue = "SecureObject";

        /// <summary> NotSpecified. </summary>
        public static LogicWorkflowParameterType NotSpecified { get; } = new LogicWorkflowParameterType(NotSpecifiedValue);
        /// <summary> String. </summary>
        public static LogicWorkflowParameterType String { get; } = new LogicWorkflowParameterType(StringValue);
        /// <summary> SecureString. </summary>
        public static LogicWorkflowParameterType SecureString { get; } = new LogicWorkflowParameterType(SecureStringValue);
        /// <summary> Int. </summary>
        public static LogicWorkflowParameterType Int { get; } = new LogicWorkflowParameterType(IntValue);
        /// <summary> Float. </summary>
        public static LogicWorkflowParameterType Float { get; } = new LogicWorkflowParameterType(FloatValue);
        /// <summary> Bool. </summary>
        public static LogicWorkflowParameterType Bool { get; } = new LogicWorkflowParameterType(BoolValue);
        /// <summary> Array. </summary>
        public static LogicWorkflowParameterType Array { get; } = new LogicWorkflowParameterType(ArrayValue);
        /// <summary> Object. </summary>
        public static LogicWorkflowParameterType Object { get; } = new LogicWorkflowParameterType(ObjectValue);
        /// <summary> SecureObject. </summary>
        public static LogicWorkflowParameterType SecureObject { get; } = new LogicWorkflowParameterType(SecureObjectValue);
        /// <summary> Determines if two <see cref="LogicWorkflowParameterType"/> values are the same. </summary>
        public static bool operator ==(LogicWorkflowParameterType left, LogicWorkflowParameterType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LogicWorkflowParameterType"/> values are not the same. </summary>
        public static bool operator !=(LogicWorkflowParameterType left, LogicWorkflowParameterType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LogicWorkflowParameterType"/>. </summary>
        public static implicit operator LogicWorkflowParameterType(string value) => new LogicWorkflowParameterType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LogicWorkflowParameterType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LogicWorkflowParameterType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
