// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The retry history. </summary>
    public partial class LogicWorkRetryHistory
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LogicWorkRetryHistory"/>. </summary>
        public LogicWorkRetryHistory()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LogicWorkRetryHistory"/>. </summary>
        /// <param name="startOn"> Gets the start time. </param>
        /// <param name="endOn"> Gets the end time. </param>
        /// <param name="code"> Gets the status code. </param>
        /// <param name="clientRequestId"> Gets the client request Id. </param>
        /// <param name="serviceRequestId"> Gets the service request Id. </param>
        /// <param name="error"> Gets the error response. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LogicWorkRetryHistory(DateTimeOffset? startOn, DateTimeOffset? endOn, string code, string clientRequestId, string serviceRequestId, LogicErrorResponse error, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StartOn = startOn;
            EndOn = endOn;
            Code = code;
            ClientRequestId = clientRequestId;
            ServiceRequestId = serviceRequestId;
            Error = error;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the start time. </summary>
        public DateTimeOffset? StartOn { get; set; }
        /// <summary> Gets the end time. </summary>
        public DateTimeOffset? EndOn { get; set; }
        /// <summary> Gets the status code. </summary>
        public string Code { get; set; }
        /// <summary> Gets the client request Id. </summary>
        public string ClientRequestId { get; set; }
        /// <summary> Gets the service request Id. </summary>
        public string ServiceRequestId { get; set; }
        /// <summary> Gets the error response. </summary>
        public LogicErrorResponse Error { get; set; }
    }
}
