// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The api operations properties. </summary>
    public partial class LogicApiOperationProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LogicApiOperationProperties"/>. </summary>
        public LogicApiOperationProperties()
        {
            ResponsesDefinition = new ChangeTrackingDictionary<string, SwaggerSchema>();
        }

        /// <summary> Initializes a new instance of <see cref="LogicApiOperationProperties"/>. </summary>
        /// <param name="summary"> The summary of the api operation. </param>
        /// <param name="description"> The description of the api operation. </param>
        /// <param name="visibility"> The visibility of the api operation. </param>
        /// <param name="trigger"> The trigger type of api operation. </param>
        /// <param name="triggerHint"> The trigger hint for the api operation. </param>
        /// <param name="isPageable"> Indicates whether the api operation is pageable. </param>
        /// <param name="annotation"> The annotation of api operation. </param>
        /// <param name="api"> The api reference. </param>
        /// <param name="inputsDefinition"> The operation inputs definition schema. </param>
        /// <param name="responsesDefinition"> The operation responses definition schemas. </param>
        /// <param name="isWebhook"> Indicates whether the API operation is webhook or not. </param>
        /// <param name="isNotification"> Indicates whether the API operation is notification or not. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LogicApiOperationProperties(string summary, string description, string visibility, string trigger, string triggerHint, bool? isPageable, LogicApiOperationAnnotation annotation, LogicApiReference api, SwaggerSchema inputsDefinition, IDictionary<string, SwaggerSchema> responsesDefinition, bool? isWebhook, bool? isNotification, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Summary = summary;
            Description = description;
            Visibility = visibility;
            Trigger = trigger;
            TriggerHint = triggerHint;
            IsPageable = isPageable;
            Annotation = annotation;
            Api = api;
            InputsDefinition = inputsDefinition;
            ResponsesDefinition = responsesDefinition;
            IsWebhook = isWebhook;
            IsNotification = isNotification;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The summary of the api operation. </summary>
        public string Summary { get; set; }
        /// <summary> The description of the api operation. </summary>
        public string Description { get; set; }
        /// <summary> The visibility of the api operation. </summary>
        public string Visibility { get; set; }
        /// <summary> The trigger type of api operation. </summary>
        public string Trigger { get; set; }
        /// <summary> The trigger hint for the api operation. </summary>
        public string TriggerHint { get; set; }
        /// <summary> Indicates whether the api operation is pageable. </summary>
        public bool? IsPageable { get; set; }
        /// <summary> The annotation of api operation. </summary>
        public LogicApiOperationAnnotation Annotation { get; set; }
        /// <summary> The api reference. </summary>
        public LogicApiReference Api { get; set; }
        /// <summary> The operation inputs definition schema. </summary>
        public SwaggerSchema InputsDefinition { get; set; }
        /// <summary> The operation responses definition schemas. </summary>
        public IDictionary<string, SwaggerSchema> ResponsesDefinition { get; }
        /// <summary> Indicates whether the API operation is webhook or not. </summary>
        public bool? IsWebhook { get; set; }
        /// <summary> Indicates whether the API operation is notification or not. </summary>
        public bool? IsNotification { get; set; }
    }
}
