// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The status annotation. </summary>
    public readonly partial struct LogicApiOperationAnnotationStatus : IEquatable<LogicApiOperationAnnotationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LogicApiOperationAnnotationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LogicApiOperationAnnotationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string PreviewValue = "Preview";
        private const string ProductionValue = "Production";

        /// <summary> NotSpecified. </summary>
        public static LogicApiOperationAnnotationStatus NotSpecified { get; } = new LogicApiOperationAnnotationStatus(NotSpecifiedValue);
        /// <summary> Preview. </summary>
        public static LogicApiOperationAnnotationStatus Preview { get; } = new LogicApiOperationAnnotationStatus(PreviewValue);
        /// <summary> Production. </summary>
        public static LogicApiOperationAnnotationStatus Production { get; } = new LogicApiOperationAnnotationStatus(ProductionValue);
        /// <summary> Determines if two <see cref="LogicApiOperationAnnotationStatus"/> values are the same. </summary>
        public static bool operator ==(LogicApiOperationAnnotationStatus left, LogicApiOperationAnnotationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LogicApiOperationAnnotationStatus"/> values are not the same. </summary>
        public static bool operator !=(LogicApiOperationAnnotationStatus left, LogicApiOperationAnnotationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LogicApiOperationAnnotationStatus"/>. </summary>
        public static implicit operator LogicApiOperationAnnotationStatus(string value) => new LogicApiOperationAnnotationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LogicApiOperationAnnotationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LogicApiOperationAnnotationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
