// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The Api deployment parameter visibility. </summary>
    public readonly partial struct LogicApiDeploymentParameterVisibility : IEquatable<LogicApiDeploymentParameterVisibility>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LogicApiDeploymentParameterVisibility"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LogicApiDeploymentParameterVisibility(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string DefaultValue = "Default";
        private const string InternalValue = "Internal";

        /// <summary> NotSpecified. </summary>
        public static LogicApiDeploymentParameterVisibility NotSpecified { get; } = new LogicApiDeploymentParameterVisibility(NotSpecifiedValue);
        /// <summary> Default. </summary>
        public static LogicApiDeploymentParameterVisibility Default { get; } = new LogicApiDeploymentParameterVisibility(DefaultValue);
        /// <summary> Internal. </summary>
        public static LogicApiDeploymentParameterVisibility Internal { get; } = new LogicApiDeploymentParameterVisibility(InternalValue);
        /// <summary> Determines if two <see cref="LogicApiDeploymentParameterVisibility"/> values are the same. </summary>
        public static bool operator ==(LogicApiDeploymentParameterVisibility left, LogicApiDeploymentParameterVisibility right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LogicApiDeploymentParameterVisibility"/> values are not the same. </summary>
        public static bool operator !=(LogicApiDeploymentParameterVisibility left, LogicApiDeploymentParameterVisibility right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LogicApiDeploymentParameterVisibility"/>. </summary>
        public static implicit operator LogicApiDeploymentParameterVisibility(string value) => new LogicApiDeploymentParameterVisibility(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LogicApiDeploymentParameterVisibility other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LogicApiDeploymentParameterVisibility other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
