// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The API deployment parameters metadata. </summary>
    public partial class LogicApiDeploymentParameterMetadataSet
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LogicApiDeploymentParameterMetadataSet"/>. </summary>
        internal LogicApiDeploymentParameterMetadataSet()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LogicApiDeploymentParameterMetadataSet"/>. </summary>
        /// <param name="packageContentLink"> The package content link parameter. </param>
        /// <param name="redisCacheConnectionString"> The package content link parameter. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LogicApiDeploymentParameterMetadataSet(LogicApiDeploymentParameterMetadata packageContentLink, LogicApiDeploymentParameterMetadata redisCacheConnectionString, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PackageContentLink = packageContentLink;
            RedisCacheConnectionString = redisCacheConnectionString;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The package content link parameter. </summary>
        public LogicApiDeploymentParameterMetadata PackageContentLink { get; }
        /// <summary> The package content link parameter. </summary>
        public LogicApiDeploymentParameterMetadata RedisCacheConnectionString { get; }
    }
}
