// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The API deployment parameter metadata. </summary>
    public partial class LogicApiDeploymentParameterMetadata
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LogicApiDeploymentParameterMetadata"/>. </summary>
        internal LogicApiDeploymentParameterMetadata()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LogicApiDeploymentParameterMetadata"/>. </summary>
        /// <param name="apiDeploymentParameterMetadataType"> The type. </param>
        /// <param name="isRequired"> Indicates whether its required. </param>
        /// <param name="displayName"> The display name. </param>
        /// <param name="description"> The description. </param>
        /// <param name="visibility"> The visibility. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LogicApiDeploymentParameterMetadata(string apiDeploymentParameterMetadataType, bool? isRequired, string displayName, string description, LogicApiDeploymentParameterVisibility? visibility, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ApiDeploymentParameterMetadataType = apiDeploymentParameterMetadataType;
            IsRequired = isRequired;
            DisplayName = displayName;
            Description = description;
            Visibility = visibility;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The type. </summary>
        public string ApiDeploymentParameterMetadataType { get; }
        /// <summary> Indicates whether its required. </summary>
        public bool? IsRequired { get; }
        /// <summary> The display name. </summary>
        public string DisplayName { get; }
        /// <summary> The description. </summary>
        public string Description { get; }
        /// <summary> The visibility. </summary>
        public LogicApiDeploymentParameterVisibility? Visibility { get; }
    }
}
