// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Logic.Models
{
    public partial class ListOperationCallbackUrlParameterInfo : IUtf8JsonSerializable, IJsonModel<ListOperationCallbackUrlParameterInfo>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ListOperationCallbackUrlParameterInfo>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ListOperationCallbackUrlParameterInfo>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ListOperationCallbackUrlParameterInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ListOperationCallbackUrlParameterInfo)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(NotAfter))
            {
                writer.WritePropertyName("notAfter"u8);
                writer.WriteStringValue(NotAfter.Value, "O");
            }
            if (Optional.IsDefined(KeyType))
            {
                writer.WritePropertyName("keyType"u8);
                writer.WriteStringValue(KeyType.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ListOperationCallbackUrlParameterInfo IJsonModel<ListOperationCallbackUrlParameterInfo>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ListOperationCallbackUrlParameterInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ListOperationCallbackUrlParameterInfo)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeListOperationCallbackUrlParameterInfo(document.RootElement, options);
        }

        internal static ListOperationCallbackUrlParameterInfo DeserializeListOperationCallbackUrlParameterInfo(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? notAfter = default;
            LogicKeyType? keyType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("notAfter"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    notAfter = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("keyType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    keyType = new LogicKeyType(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ListOperationCallbackUrlParameterInfo(notAfter, keyType, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ListOperationCallbackUrlParameterInfo>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ListOperationCallbackUrlParameterInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ListOperationCallbackUrlParameterInfo)} does not support writing '{options.Format}' format.");
            }
        }

        ListOperationCallbackUrlParameterInfo IPersistableModel<ListOperationCallbackUrlParameterInfo>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ListOperationCallbackUrlParameterInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeListOperationCallbackUrlParameterInfo(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ListOperationCallbackUrlParameterInfo)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ListOperationCallbackUrlParameterInfo>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
