// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The error response code. </summary>
    public readonly partial struct IntegrationServiceErrorCode : IEquatable<IntegrationServiceErrorCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IntegrationServiceErrorCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IntegrationServiceErrorCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string IntegrationServiceEnvironmentNotFoundValue = "IntegrationServiceEnvironmentNotFound";
        private const string InternalServerErrorValue = "InternalServerError";
        private const string InvalidOperationIdValue = "InvalidOperationId";

        /// <summary> NotSpecified. </summary>
        public static IntegrationServiceErrorCode NotSpecified { get; } = new IntegrationServiceErrorCode(NotSpecifiedValue);
        /// <summary> IntegrationServiceEnvironmentNotFound. </summary>
        public static IntegrationServiceErrorCode IntegrationServiceEnvironmentNotFound { get; } = new IntegrationServiceErrorCode(IntegrationServiceEnvironmentNotFoundValue);
        /// <summary> InternalServerError. </summary>
        public static IntegrationServiceErrorCode InternalServerError { get; } = new IntegrationServiceErrorCode(InternalServerErrorValue);
        /// <summary> InvalidOperationId. </summary>
        public static IntegrationServiceErrorCode InvalidOperationId { get; } = new IntegrationServiceErrorCode(InvalidOperationIdValue);
        /// <summary> Determines if two <see cref="IntegrationServiceErrorCode"/> values are the same. </summary>
        public static bool operator ==(IntegrationServiceErrorCode left, IntegrationServiceErrorCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IntegrationServiceErrorCode"/> values are not the same. </summary>
        public static bool operator !=(IntegrationServiceErrorCode left, IntegrationServiceErrorCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IntegrationServiceErrorCode"/>. </summary>
        public static implicit operator IntegrationServiceErrorCode(string value) => new IntegrationServiceErrorCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IntegrationServiceErrorCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IntegrationServiceErrorCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
