// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The integration service environment subnet network health. </summary>
    public partial class IntegrationServiceEnvironmentSubnetNetworkHealth
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IntegrationServiceEnvironmentSubnetNetworkHealth"/>. </summary>
        /// <param name="networkDependencyHealthState"> The integration service environment network health state. </param>
        internal IntegrationServiceEnvironmentSubnetNetworkHealth(IntegrationServiceEnvironmentNetworkEndPointAccessibilityState networkDependencyHealthState)
        {
            OutboundNetworkDependencies = new ChangeTrackingList<IntegrationServiceEnvironmentNetworkDependency>();
            NetworkDependencyHealthState = networkDependencyHealthState;
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationServiceEnvironmentSubnetNetworkHealth"/>. </summary>
        /// <param name="outboundNetworkDependencies"> The outbound network dependencies. </param>
        /// <param name="outboundNetworkHealth"> The integration service environment network health. </param>
        /// <param name="networkDependencyHealthState"> The integration service environment network health state. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IntegrationServiceEnvironmentSubnetNetworkHealth(IReadOnlyList<IntegrationServiceEnvironmentNetworkDependency> outboundNetworkDependencies, IntegrationServiceEnvironmentNetworkDependencyHealth outboundNetworkHealth, IntegrationServiceEnvironmentNetworkEndPointAccessibilityState networkDependencyHealthState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OutboundNetworkDependencies = outboundNetworkDependencies;
            OutboundNetworkHealth = outboundNetworkHealth;
            NetworkDependencyHealthState = networkDependencyHealthState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationServiceEnvironmentSubnetNetworkHealth"/> for deserialization. </summary>
        internal IntegrationServiceEnvironmentSubnetNetworkHealth()
        {
        }

        /// <summary> The outbound network dependencies. </summary>
        public IReadOnlyList<IntegrationServiceEnvironmentNetworkDependency> OutboundNetworkDependencies { get; }
        /// <summary> The integration service environment network health. </summary>
        public IntegrationServiceEnvironmentNetworkDependencyHealth OutboundNetworkHealth { get; }
        /// <summary> The integration service environment network health state. </summary>
        public IntegrationServiceEnvironmentNetworkEndPointAccessibilityState NetworkDependencyHealthState { get; }
    }
}
