// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The integration service environment sku scale type. </summary>
    public readonly partial struct IntegrationServiceEnvironmentSkuScaleType : IEquatable<IntegrationServiceEnvironmentSkuScaleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IntegrationServiceEnvironmentSkuScaleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IntegrationServiceEnvironmentSkuScaleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ManualValue = "Manual";
        private const string AutomaticValue = "Automatic";
        private const string NoneValue = "None";

        /// <summary> Manual. </summary>
        public static IntegrationServiceEnvironmentSkuScaleType Manual { get; } = new IntegrationServiceEnvironmentSkuScaleType(ManualValue);
        /// <summary> Automatic. </summary>
        public static IntegrationServiceEnvironmentSkuScaleType Automatic { get; } = new IntegrationServiceEnvironmentSkuScaleType(AutomaticValue);
        /// <summary> None. </summary>
        public static IntegrationServiceEnvironmentSkuScaleType None { get; } = new IntegrationServiceEnvironmentSkuScaleType(NoneValue);
        /// <summary> Determines if two <see cref="IntegrationServiceEnvironmentSkuScaleType"/> values are the same. </summary>
        public static bool operator ==(IntegrationServiceEnvironmentSkuScaleType left, IntegrationServiceEnvironmentSkuScaleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IntegrationServiceEnvironmentSkuScaleType"/> values are not the same. </summary>
        public static bool operator !=(IntegrationServiceEnvironmentSkuScaleType left, IntegrationServiceEnvironmentSkuScaleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IntegrationServiceEnvironmentSkuScaleType"/>. </summary>
        public static implicit operator IntegrationServiceEnvironmentSkuScaleType(string value) => new IntegrationServiceEnvironmentSkuScaleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IntegrationServiceEnvironmentSkuScaleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IntegrationServiceEnvironmentSkuScaleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
