// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The integration service environment sku name. </summary>
    public readonly partial struct IntegrationServiceEnvironmentSkuName : IEquatable<IntegrationServiceEnvironmentSkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IntegrationServiceEnvironmentSkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IntegrationServiceEnvironmentSkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string PremiumValue = "Premium";
        private const string DeveloperValue = "Developer";

        /// <summary> NotSpecified. </summary>
        public static IntegrationServiceEnvironmentSkuName NotSpecified { get; } = new IntegrationServiceEnvironmentSkuName(NotSpecifiedValue);
        /// <summary> Premium. </summary>
        public static IntegrationServiceEnvironmentSkuName Premium { get; } = new IntegrationServiceEnvironmentSkuName(PremiumValue);
        /// <summary> Developer. </summary>
        public static IntegrationServiceEnvironmentSkuName Developer { get; } = new IntegrationServiceEnvironmentSkuName(DeveloperValue);
        /// <summary> Determines if two <see cref="IntegrationServiceEnvironmentSkuName"/> values are the same. </summary>
        public static bool operator ==(IntegrationServiceEnvironmentSkuName left, IntegrationServiceEnvironmentSkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IntegrationServiceEnvironmentSkuName"/> values are not the same. </summary>
        public static bool operator !=(IntegrationServiceEnvironmentSkuName left, IntegrationServiceEnvironmentSkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IntegrationServiceEnvironmentSkuName"/>. </summary>
        public static implicit operator IntegrationServiceEnvironmentSkuName(string value) => new IntegrationServiceEnvironmentSkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IntegrationServiceEnvironmentSkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IntegrationServiceEnvironmentSkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
