// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The integration service environment sku definition. </summary>
    public partial class IntegrationServiceEnvironmentSkuDefinition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IntegrationServiceEnvironmentSkuDefinition"/>. </summary>
        internal IntegrationServiceEnvironmentSkuDefinition()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationServiceEnvironmentSkuDefinition"/>. </summary>
        /// <param name="resourceType"> The resource type. </param>
        /// <param name="sku"> The sku. </param>
        /// <param name="capacity"> The sku capacity. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IntegrationServiceEnvironmentSkuDefinition(ResourceType? resourceType, IntegrationServiceEnvironmentSkuDefinitionSku sku, IntegrationServiceEnvironmentSkuCapacity capacity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceType = resourceType;
            Sku = sku;
            Capacity = capacity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The resource type. </summary>
        public ResourceType? ResourceType { get; }
        /// <summary> The sku. </summary>
        public IntegrationServiceEnvironmentSkuDefinitionSku Sku { get; }
        /// <summary> The sku capacity. </summary>
        public IntegrationServiceEnvironmentSkuCapacity Capacity { get; }
    }
}
