// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The integration service environment network endpoint accessibility state. </summary>
    public readonly partial struct IntegrationServiceEnvironmentNetworkEndPointAccessibilityState : IEquatable<IntegrationServiceEnvironmentNetworkEndPointAccessibilityState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IntegrationServiceEnvironmentNetworkEndPointAccessibilityState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IntegrationServiceEnvironmentNetworkEndPointAccessibilityState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string UnknownValue = "Unknown";
        private const string AvailableValue = "Available";
        private const string NotAvailableValue = "NotAvailable";

        /// <summary> NotSpecified. </summary>
        public static IntegrationServiceEnvironmentNetworkEndPointAccessibilityState NotSpecified { get; } = new IntegrationServiceEnvironmentNetworkEndPointAccessibilityState(NotSpecifiedValue);
        /// <summary> Unknown. </summary>
        public static IntegrationServiceEnvironmentNetworkEndPointAccessibilityState Unknown { get; } = new IntegrationServiceEnvironmentNetworkEndPointAccessibilityState(UnknownValue);
        /// <summary> Available. </summary>
        public static IntegrationServiceEnvironmentNetworkEndPointAccessibilityState Available { get; } = new IntegrationServiceEnvironmentNetworkEndPointAccessibilityState(AvailableValue);
        /// <summary> NotAvailable. </summary>
        public static IntegrationServiceEnvironmentNetworkEndPointAccessibilityState NotAvailable { get; } = new IntegrationServiceEnvironmentNetworkEndPointAccessibilityState(NotAvailableValue);
        /// <summary> Determines if two <see cref="IntegrationServiceEnvironmentNetworkEndPointAccessibilityState"/> values are the same. </summary>
        public static bool operator ==(IntegrationServiceEnvironmentNetworkEndPointAccessibilityState left, IntegrationServiceEnvironmentNetworkEndPointAccessibilityState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IntegrationServiceEnvironmentNetworkEndPointAccessibilityState"/> values are not the same. </summary>
        public static bool operator !=(IntegrationServiceEnvironmentNetworkEndPointAccessibilityState left, IntegrationServiceEnvironmentNetworkEndPointAccessibilityState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IntegrationServiceEnvironmentNetworkEndPointAccessibilityState"/>. </summary>
        public static implicit operator IntegrationServiceEnvironmentNetworkEndPointAccessibilityState(string value) => new IntegrationServiceEnvironmentNetworkEndPointAccessibilityState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IntegrationServiceEnvironmentNetworkEndPointAccessibilityState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IntegrationServiceEnvironmentNetworkEndPointAccessibilityState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
