// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The integration service environment network dependency health state. </summary>
    public readonly partial struct IntegrationServiceEnvironmentNetworkDependencyHealthState : IEquatable<IntegrationServiceEnvironmentNetworkDependencyHealthState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IntegrationServiceEnvironmentNetworkDependencyHealthState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IntegrationServiceEnvironmentNetworkDependencyHealthState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string HealthyValue = "Healthy";
        private const string UnhealthyValue = "Unhealthy";
        private const string UnknownValue = "Unknown";

        /// <summary> NotSpecified. </summary>
        public static IntegrationServiceEnvironmentNetworkDependencyHealthState NotSpecified { get; } = new IntegrationServiceEnvironmentNetworkDependencyHealthState(NotSpecifiedValue);
        /// <summary> Healthy. </summary>
        public static IntegrationServiceEnvironmentNetworkDependencyHealthState Healthy { get; } = new IntegrationServiceEnvironmentNetworkDependencyHealthState(HealthyValue);
        /// <summary> Unhealthy. </summary>
        public static IntegrationServiceEnvironmentNetworkDependencyHealthState Unhealthy { get; } = new IntegrationServiceEnvironmentNetworkDependencyHealthState(UnhealthyValue);
        /// <summary> Unknown. </summary>
        public static IntegrationServiceEnvironmentNetworkDependencyHealthState Unknown { get; } = new IntegrationServiceEnvironmentNetworkDependencyHealthState(UnknownValue);
        /// <summary> Determines if two <see cref="IntegrationServiceEnvironmentNetworkDependencyHealthState"/> values are the same. </summary>
        public static bool operator ==(IntegrationServiceEnvironmentNetworkDependencyHealthState left, IntegrationServiceEnvironmentNetworkDependencyHealthState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IntegrationServiceEnvironmentNetworkDependencyHealthState"/> values are not the same. </summary>
        public static bool operator !=(IntegrationServiceEnvironmentNetworkDependencyHealthState left, IntegrationServiceEnvironmentNetworkDependencyHealthState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IntegrationServiceEnvironmentNetworkDependencyHealthState"/>. </summary>
        public static implicit operator IntegrationServiceEnvironmentNetworkDependencyHealthState(string value) => new IntegrationServiceEnvironmentNetworkDependencyHealthState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IntegrationServiceEnvironmentNetworkDependencyHealthState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IntegrationServiceEnvironmentNetworkDependencyHealthState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
