// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The integration service environment access endpoint type. </summary>
    public readonly partial struct IntegrationServiceEnvironmentAccessEndpointType : IEquatable<IntegrationServiceEnvironmentAccessEndpointType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IntegrationServiceEnvironmentAccessEndpointType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IntegrationServiceEnvironmentAccessEndpointType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string ExternalValue = "External";
        private const string InternalValue = "Internal";

        /// <summary> NotSpecified. </summary>
        public static IntegrationServiceEnvironmentAccessEndpointType NotSpecified { get; } = new IntegrationServiceEnvironmentAccessEndpointType(NotSpecifiedValue);
        /// <summary> External. </summary>
        public static IntegrationServiceEnvironmentAccessEndpointType External { get; } = new IntegrationServiceEnvironmentAccessEndpointType(ExternalValue);
        /// <summary> Internal. </summary>
        public static IntegrationServiceEnvironmentAccessEndpointType Internal { get; } = new IntegrationServiceEnvironmentAccessEndpointType(InternalValue);
        /// <summary> Determines if two <see cref="IntegrationServiceEnvironmentAccessEndpointType"/> values are the same. </summary>
        public static bool operator ==(IntegrationServiceEnvironmentAccessEndpointType left, IntegrationServiceEnvironmentAccessEndpointType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IntegrationServiceEnvironmentAccessEndpointType"/> values are not the same. </summary>
        public static bool operator !=(IntegrationServiceEnvironmentAccessEndpointType left, IntegrationServiceEnvironmentAccessEndpointType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IntegrationServiceEnvironmentAccessEndpointType"/>. </summary>
        public static implicit operator IntegrationServiceEnvironmentAccessEndpointType(string value) => new IntegrationServiceEnvironmentAccessEndpointType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IntegrationServiceEnvironmentAccessEndpointType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IntegrationServiceEnvironmentAccessEndpointType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
