// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The tracking events definition. </summary>
    public partial class IntegrationAccountTrackingEventsContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountTrackingEventsContent"/>. </summary>
        /// <param name="sourceType"> The source type. </param>
        /// <param name="events"> The events. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sourceType"/> or <paramref name="events"/> is null. </exception>
        public IntegrationAccountTrackingEventsContent(string sourceType, IEnumerable<IntegrationAccountTrackingEvent> events)
        {
            Argument.AssertNotNull(sourceType, nameof(sourceType));
            Argument.AssertNotNull(events, nameof(events));

            SourceType = sourceType;
            Events = events.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountTrackingEventsContent"/>. </summary>
        /// <param name="sourceType"> The source type. </param>
        /// <param name="trackEventsOptions"> The track events options. </param>
        /// <param name="events"> The events. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IntegrationAccountTrackingEventsContent(string sourceType, IntegrationAccountTrackEventOperationOption? trackEventsOptions, IList<IntegrationAccountTrackingEvent> events, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SourceType = sourceType;
            TrackEventsOptions = trackEventsOptions;
            Events = events;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountTrackingEventsContent"/> for deserialization. </summary>
        internal IntegrationAccountTrackingEventsContent()
        {
        }

        /// <summary> The source type. </summary>
        public string SourceType { get; }
        /// <summary> The track events options. </summary>
        public IntegrationAccountTrackEventOperationOption? TrackEventsOptions { get; set; }
        /// <summary> The events. </summary>
        public IList<IntegrationAccountTrackingEvent> Events { get; }
    }
}
