// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Logic.Models
{
    public partial class IntegrationAccountTrackingEvent : IUtf8JsonSerializable, IJsonModel<IntegrationAccountTrackingEvent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<IntegrationAccountTrackingEvent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<IntegrationAccountTrackingEvent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IntegrationAccountTrackingEvent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IntegrationAccountTrackingEvent)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("eventLevel"u8);
            writer.WriteStringValue(EventLevel.ToSerialString());
            writer.WritePropertyName("eventTime"u8);
            writer.WriteStringValue(EventOn, "O");
            writer.WritePropertyName("recordType"u8);
            writer.WriteStringValue(RecordType.ToString());
            if (Optional.IsDefined(Record))
            {
                writer.WritePropertyName("record"u8);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(Record);
#else
                using (JsonDocument document = JsonDocument.Parse(Record))
                {
                    JsonSerializer.Serialize(writer, document.RootElement);
                }
#endif
            }
            if (Optional.IsDefined(Error))
            {
                writer.WritePropertyName("error"u8);
                writer.WriteObjectValue(Error, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        IntegrationAccountTrackingEvent IJsonModel<IntegrationAccountTrackingEvent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IntegrationAccountTrackingEvent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IntegrationAccountTrackingEvent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeIntegrationAccountTrackingEvent(document.RootElement, options);
        }

        internal static IntegrationAccountTrackingEvent DeserializeIntegrationAccountTrackingEvent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IntegrationAccountEventLevel eventLevel = default;
            DateTimeOffset eventTime = default;
            IntegrationAccountTrackingRecordType recordType = default;
            BinaryData record = default;
            IntegrationAccountTrackingEventErrorInfo error = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("eventLevel"u8))
                {
                    eventLevel = property.Value.GetString().ToIntegrationAccountEventLevel();
                    continue;
                }
                if (property.NameEquals("eventTime"u8))
                {
                    eventTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("recordType"u8))
                {
                    recordType = new IntegrationAccountTrackingRecordType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("record"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    record = BinaryData.FromString(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("error"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    error = IntegrationAccountTrackingEventErrorInfo.DeserializeIntegrationAccountTrackingEventErrorInfo(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new IntegrationAccountTrackingEvent(
                eventLevel,
                eventTime,
                recordType,
                record,
                error,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<IntegrationAccountTrackingEvent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IntegrationAccountTrackingEvent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(IntegrationAccountTrackingEvent)} does not support writing '{options.Format}' format.");
            }
        }

        IntegrationAccountTrackingEvent IPersistableModel<IntegrationAccountTrackingEvent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IntegrationAccountTrackingEvent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeIntegrationAccountTrackingEvent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(IntegrationAccountTrackingEvent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<IntegrationAccountTrackingEvent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
