// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The track events operation options. </summary>
    public readonly partial struct IntegrationAccountTrackEventOperationOption : IEquatable<IntegrationAccountTrackEventOperationOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountTrackEventOperationOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IntegrationAccountTrackEventOperationOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string DisableSourceInfoEnrichValue = "DisableSourceInfoEnrich";

        /// <summary> None. </summary>
        public static IntegrationAccountTrackEventOperationOption None { get; } = new IntegrationAccountTrackEventOperationOption(NoneValue);
        /// <summary> DisableSourceInfoEnrich. </summary>
        public static IntegrationAccountTrackEventOperationOption DisableSourceInfoEnrich { get; } = new IntegrationAccountTrackEventOperationOption(DisableSourceInfoEnrichValue);
        /// <summary> Determines if two <see cref="IntegrationAccountTrackEventOperationOption"/> values are the same. </summary>
        public static bool operator ==(IntegrationAccountTrackEventOperationOption left, IntegrationAccountTrackEventOperationOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IntegrationAccountTrackEventOperationOption"/> values are not the same. </summary>
        public static bool operator !=(IntegrationAccountTrackEventOperationOption left, IntegrationAccountTrackEventOperationOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IntegrationAccountTrackEventOperationOption"/>. </summary>
        public static implicit operator IntegrationAccountTrackEventOperationOption(string value) => new IntegrationAccountTrackEventOperationOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IntegrationAccountTrackEventOperationOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IntegrationAccountTrackEventOperationOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
