// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The integration account sku name. </summary>
    public readonly partial struct IntegrationAccountSkuName : IEquatable<IntegrationAccountSkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountSkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IntegrationAccountSkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string FreeValue = "Free";
        private const string BasicValue = "Basic";
        private const string StandardValue = "Standard";

        /// <summary> NotSpecified. </summary>
        public static IntegrationAccountSkuName NotSpecified { get; } = new IntegrationAccountSkuName(NotSpecifiedValue);
        /// <summary> Free. </summary>
        public static IntegrationAccountSkuName Free { get; } = new IntegrationAccountSkuName(FreeValue);
        /// <summary> Basic. </summary>
        public static IntegrationAccountSkuName Basic { get; } = new IntegrationAccountSkuName(BasicValue);
        /// <summary> Standard. </summary>
        public static IntegrationAccountSkuName Standard { get; } = new IntegrationAccountSkuName(StandardValue);
        /// <summary> Determines if two <see cref="IntegrationAccountSkuName"/> values are the same. </summary>
        public static bool operator ==(IntegrationAccountSkuName left, IntegrationAccountSkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IntegrationAccountSkuName"/> values are not the same. </summary>
        public static bool operator !=(IntegrationAccountSkuName left, IntegrationAccountSkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IntegrationAccountSkuName"/>. </summary>
        public static implicit operator IntegrationAccountSkuName(string value) => new IntegrationAccountSkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IntegrationAccountSkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IntegrationAccountSkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
